package de.tu.darmstadt.lt.ner.feature.extractor;

import de.tu.darmstadt.lt.ner.reader.NERLookupCaching;
import lombok.SneakyThrows;
import lombok.val;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.function.FeatureFunction;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;

/**
 * Created by Markus Ackermann.
 * No rights reserved.
 */
public interface TwoColumnMapExtractor extends FeatureFunction{

    String featureName();

    String zipEntryName();

    String notFoundValue();

    @Override
    @SneakyThrows(ExecutionException.class)
    default List<Feature> apply(Feature input) {

        val lookupMap = NERLookupCaching.twoColumMappingCache().get(zipEntryName());

        val tokenString = input.getValue().toString();

        val featureValue = lookupMap.getOrDefault(tokenString, notFoundValue());

        return Collections.singletonList(new Feature(featureName(), featureValue));
    }
}
