/*******************************************************************************
 * Copyright 2014
 * FG Language Technology
 * Technische Universität Darmstadt
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package de.tu.darmstadt.lt.ner.feature.extractor;

import com.google.common.collect.ImmutableList;
import de.tu.darmstadt.lt.ner.types.FreeBaseMatch;
import de.tudarmstadt.ukp.dkpro.core.api.segmentation.type.Token;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.NamedFeatureExtractor1;


import java.util.List;

public class FreeBaseFeatureExtractor implements NamedFeatureExtractor1<Token> {

    public static final String DEFAULT_NAME = "FreebaseFeature";

    @Override
    public String getFeatureName() {
        return "FreeBase";
    }

    @Override
    public List<Feature> extract(JCas view, Token tokenInFocus) throws CleartkExtractorException {

        String featureValue = JCasUtil.selectCovered(view, FreeBaseMatch.class, tokenInFocus)
                .stream().findFirst().map(fb -> fb.getBITag()).orElse("null");

        return ImmutableList.of(new Feature(getFeatureName(), featureValue));
    }
}
