package de.tu.darmstadt.lt.ner.feature.extractor;

import de.tu.darmstadt.lt.ner.reader.NERLookupCaching;
import lombok.SneakyThrows;
import lombok.val;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.function.FeatureFunction;
import scala.Tuple2;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

import java.util.concurrent.ExecutionException;

/**
 * Created by Markus Ackermann.
 * No rights reserved.
 */
public interface DBNameListExtractor extends FeatureFunction {

    String defaultName();

    default String featureName() {

        return defaultName();
    };

    String entryName();

    @Override
    @SneakyThrows(ExecutionException.class)
    default List<Feature> apply(Feature input) {

        val nameMap = NERLookupCaching.customMapCache().get(defaultName(), () -> readData());

        val tokenString = input.getValue().toString();

        val featureValue = nameMap.getOrDefault(tokenString, "O");

        return Collections.singletonList(new Feature(featureName(), featureValue));
    }

    @SneakyThrows
    default Map<String, String> readData() {

        return NERLookupCaching.readMapData(entryName(),defaultName(), line -> {

            val st = new StringTokenizer(line, "\t");

            return new Tuple2<>(st.nextToken(), "B");

        });
    }
}
