/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.socket;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.DecoratingSeekableByteChannel;
import de.schlichtherle.truezip.io.OutputClosedException;
import de.schlichtherle.truezip.socket.DecoratingOutputShop;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.JSE7;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.Iterator;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class DisconnectingOutputShop<E extends Entry>
extends DecoratingOutputShop<E, OutputShop<E>> {
    private static final SocketFactory SOCKET_FACTORY = JSE7.AVAILABLE ? SocketFactory.NIO2 : SocketFactory.OIO;
    private boolean closed;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public DisconnectingOutputShop(@WillCloseWhenClosed OutputShop<E> output) {
        super(output);
    }

    public boolean isClosed() {
        return this.closed;
    }

    final void assertOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException(new OutputClosedException());
        }
    }

    final void checkOpen() throws IOException {
        if (this.isClosed()) {
            throw new OutputClosedException();
        }
    }

    @Override
    public int getSize() {
        this.assertOpen();
        return ((OutputShop)this.delegate).getSize();
    }

    @Override
    public Iterator<E> iterator() {
        this.assertOpen();
        return ((OutputShop)this.delegate).iterator();
    }

    @Override
    public E getEntry(String name) {
        this.assertOpen();
        return ((OutputShop)this.delegate).getEntry(name);
    }

    @Override
    public final OutputSocket<? extends E> getOutputSocket(E entry) {
        return SOCKET_FACTORY.newOutputSocket(this, ((OutputShop)this.delegate).getOutputSocket(entry));
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        ((OutputShop)this.delegate).close();
    }

    private final class DisconnectingOutputStream
    extends DecoratingOutputStream {
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        DisconnectingOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            DisconnectingOutputShop.this.checkOpen();
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            DisconnectingOutputShop.this.checkOpen();
            this.delegate.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            DisconnectingOutputShop.this.checkOpen();
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            if (!DisconnectingOutputShop.this.closed) {
                this.delegate.close();
            }
        }
    }

    private final class DisconnectingSeekableByteChannel
    extends DecoratingSeekableByteChannel {
        @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
        DisconnectingSeekableByteChannel(SeekableByteChannel sbc) {
            super(sbc);
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            DisconnectingOutputShop.this.checkOpen();
            return this.delegate.read(dst);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            DisconnectingOutputShop.this.checkOpen();
            return this.delegate.write(src);
        }

        @Override
        public long position() throws IOException {
            DisconnectingOutputShop.this.checkOpen();
            return this.delegate.position();
        }

        @Override
        public SeekableByteChannel position(long newPosition) throws IOException {
            DisconnectingOutputShop.this.checkOpen();
            this.delegate.position(newPosition);
            return this;
        }

        @Override
        public long size() throws IOException {
            DisconnectingOutputShop.this.checkOpen();
            return this.delegate.size();
        }

        @Override
        public SeekableByteChannel truncate(long size) throws IOException {
            DisconnectingOutputShop.this.checkOpen();
            this.delegate.truncate(size);
            return this;
        }

        @Override
        public boolean isOpen() {
            return !DisconnectingOutputShop.this.closed && this.delegate.isOpen();
        }

        @Override
        public void close() throws IOException {
            if (!DisconnectingOutputShop.this.closed) {
                this.delegate.close();
            }
        }
    }

    private class Output
    extends DecoratingOutputSocket<E> {
        Output(OutputSocket<? extends E> output) {
            super(output);
        }

        @Override
        protected OutputSocket<? extends E> getBoundSocket() throws IOException {
            DisconnectingOutputShop.this.checkOpen();
            return this.getDelegate().bind(this);
        }

        @Override
        public OutputStream newOutputStream() throws IOException {
            return new DisconnectingOutputStream(this.getBoundSocket().newOutputStream());
        }
    }

    private class Nio2Output
    extends Output {
        Nio2Output(OutputSocket<? extends E> output) {
            super(output);
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            return new DisconnectingSeekableByteChannel(this.getBoundSocket().newSeekableByteChannel());
        }
    }

    @Immutable
    private static enum SocketFactory {
        NIO2{

            @Override
            <E extends Entry> OutputSocket<? extends E> newOutputSocket(DisconnectingOutputShop<E> shop, OutputSocket<? extends E> output) {
                DisconnectingOutputShop<E> disconnectingOutputShop = shop;
                disconnectingOutputShop.getClass();
                return disconnectingOutputShop.new Nio2Output(output);
            }
        }
        ,
        OIO{

            @Override
            <E extends Entry> OutputSocket<? extends E> newOutputSocket(DisconnectingOutputShop<E> shop, OutputSocket<? extends E> output) {
                DisconnectingOutputShop<E> disconnectingOutputShop = shop;
                disconnectingOutputShop.getClass();
                return disconnectingOutputShop.new Output(output);
            }
        };


        abstract <E extends Entry> OutputSocket<? extends E> newOutputSocket(DisconnectingOutputShop<E> var1, OutputSocket<? extends E> var2);
    }
}

