/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsCompositeDriver;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncExceptionBuilder;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.FsSyncOptions;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ExceptionHandler;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class FsManager
implements Iterable<FsController<?>> {
    @Deprecated
    public static final BitField<FsSyncOption> UMOUNT = FsSyncOptions.UMOUNT;

    public abstract FsController<?> getController(FsMountPoint var1, FsCompositeDriver var2);

    public abstract int getSize();

    @Override
    public abstract Iterator<FsController<?>> iterator();

    public final void sync(BitField<FsSyncOption> options) throws FsSyncException {
        FsSyncExceptionBuilder builder = new FsSyncExceptionBuilder();
        this.sync(options, builder);
        builder.check();
    }

    public <X extends IOException> void sync(BitField<FsSyncOption> options, ExceptionHandler<? super IOException, X> handler) throws X {
        if (options.get(FsSyncOption.FORCE_CLOSE_OUTPUT) && !options.get(FsSyncOption.FORCE_CLOSE_INPUT) || options.get(FsSyncOption.ABORT_CHANGES)) {
            throw new IllegalArgumentException();
        }
        for (FsController<?> controller : this) {
            try {
                controller.sync(options, handler);
            }
            catch (IOException ex) {
                handler.warn(ex);
            }
        }
    }

    public final boolean equals(Object that) {
        return this == that;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return String.format("%s[size=%d]", this.getClass().getName(), this.getSize());
    }
}

