/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.archive.FsCharsetArchiveDriver;
import de.schlichtherle.truezip.fs.archive.FsMultiplexedOutputShop;
import de.schlichtherle.truezip.fs.archive.zip.KeyManagerZipCryptoParameters;
import de.schlichtherle.truezip.fs.archive.zip.KeyProviderSyncStrategy;
import de.schlichtherle.truezip.fs.archive.zip.OptionOutputSocket;
import de.schlichtherle.truezip.fs.archive.zip.ZipController;
import de.schlichtherle.truezip.fs.archive.zip.ZipDriverEntry;
import de.schlichtherle.truezip.fs.archive.zip.ZipInputShop;
import de.schlichtherle.truezip.fs.archive.zip.ZipOutputShop;
import de.schlichtherle.truezip.key.KeyManagerProvider;
import de.schlichtherle.truezip.key.sl.KeyManagerLocator;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.JSE7;
import de.schlichtherle.truezip.zip.ZipCryptoParameters;
import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipFileParameters;
import de.schlichtherle.truezip.zip.ZipOutputStreamParameters;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ZipDriver
extends FsCharsetArchiveDriver<ZipDriverEntry>
implements ZipOutputStreamParameters,
ZipFileParameters<ZipDriverEntry> {
    private static final Logger logger = Logger.getLogger(ZipDriver.class.getName(), ZipDriver.class.getName());
    private static final Charset ZIP_CHARSET = Charset.forName("IBM437");
    private final IOPool<?> ioPool;

    public ZipDriver(IOPoolProvider ioPoolProvider) {
        this(ioPoolProvider, ZIP_CHARSET);
    }

    protected ZipDriver(IOPoolProvider provider, Charset charset) {
        super(charset);
        this.ioPool = provider.get();
        if (null == this.ioPool) {
            throw new NullPointerException();
        }
    }

    protected KeyProviderSyncStrategy getKeyProviderSyncStrategy() {
        return KeyProviderSyncStrategy.RESET_CANCELLED_KEY;
    }

    protected KeyManagerProvider getKeyManagerProvider() {
        return KeyManagerLocator.SINGLETON;
    }

    @CheckForNull
    final ZipCryptoParameters zipCryptoParameters(ZipInputShop input) {
        return this.zipCryptoParameters(input.getModel(), input.getRawCharset());
    }

    @CheckForNull
    final ZipCryptoParameters zipCryptoParameters(ZipOutputShop output) {
        return this.zipCryptoParameters(output.getModel(), output.getRawCharset());
    }

    @CheckForNull
    protected ZipCryptoParameters zipCryptoParameters(FsModel model, Charset charset) {
        return new KeyManagerZipCryptoParameters(this, model, charset);
    }

    public URI mountPointUri(FsModel model) {
        return model.getMountPoint().toHierarchicalUri();
    }

    public URI resourceUri(FsModel model, String name) {
        return this.mountPointUri(model);
    }

    public boolean getRedundantContentSupport() {
        return true;
    }

    public boolean getRedundantMetaDataSupport() {
        return true;
    }

    protected boolean check(@WillNotClose ZipInputShop input, ZipDriverEntry entry) {
        return entry.isEncrypted();
    }

    final boolean process(@WillNotClose ZipInputShop input, ZipDriverEntry local, ZipDriverEntry peer) {
        return this.process(local, peer);
    }

    final boolean process(@WillNotClose ZipOutputShop output, ZipDriverEntry local, ZipDriverEntry peer) {
        return this.process(peer, local);
    }

    protected boolean process(ZipDriverEntry input, ZipDriverEntry output) {
        return input.isEncrypted() || output.isEncrypted();
    }

    protected final IOPool<?> getPool() {
        return this.ioPool;
    }

    @Override
    public boolean getPreambled() {
        return false;
    }

    @Override
    public boolean getPostambled() {
        return false;
    }

    @Override
    @Deprecated
    public int getOverheadSize() {
        return 47;
    }

    @Override
    public int getMethod() {
        return 8;
    }

    @Override
    public int getLevel() {
        return 9;
    }

    public FsController<?> newController(FsModel model, FsController<?> parent) {
        return new ZipController(this.superNewController(model, parent), this);
    }

    protected final FsController<?> superNewController(FsModel model, FsController<?> parent) {
        return super.newController(model, parent);
    }

    public ZipDriverEntry newEntry(String name, Entry.Type type, Entry template, BitField<FsOutputOption> mknod) throws CharConversionException {
        ZipDriverEntry entry;
        name = ZipDriver.toZipOrTarEntryName((String)name, (Entry.Type)type);
        if (template instanceof ZipEntry) {
            entry = this.newEntry(name, (ZipEntry)template);
        } else {
            entry = this.newEntry(name);
            if (null != template) {
                entry.setTime(template.getTime(Entry.Access.WRITE));
                entry.setSize(template.getSize(Entry.Size.DATA));
            }
        }
        if (mknod.get((Enum)FsOutputOption.COMPRESS)) {
            entry.setMethod(8);
        } else if (mknod.get((Enum)FsOutputOption.STORE)) {
            entry.setMethod(0);
        }
        if (Entry.Type.DIRECTORY != type) {
            if (-1 == entry.getMethod()) {
                int method = this.getMethod();
                entry.setMethod(method);
                if (0 != method) {
                    entry.setCompressedSize(-1L);
                }
            }
            if (mknod.get((Enum)FsOutputOption.ENCRYPT)) {
                entry.setEncrypted(true);
            }
        }
        return entry;
    }

    @Override
    public ZipDriverEntry newEntry(String name) {
        return new ZipDriverEntry(name);
    }

    public ZipDriverEntry newEntry(String name, ZipEntry template) {
        return new ZipDriverEntry(name, template);
    }

    public InputShop<ZipDriverEntry> newInputShop(FsModel model, InputSocket<?> input) throws IOException {
        if (null == model) {
            throw new NullPointerException();
        }
        ReadOnlyFile rof = input.newReadOnlyFile();
        try {
            return this.newInputShop(model, rof);
        }
        catch (IOException ex) {
            block5: {
                try {
                    rof.close();
                }
                catch (IOException ex2) {
                    if (!JSE7.AVAILABLE) break block5;
                    ex.addSuppressed(ex2);
                }
            }
            throw ex;
        }
    }

    @CreatesObligation
    protected InputShop<ZipDriverEntry> newInputShop(FsModel model, @WillCloseWhenClosed ReadOnlyFile rof) throws IOException {
        assert (null != model);
        ZipInputShop input = new ZipInputShop(this, model, rof);
        try {
            input.recoverLostEntries();
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "junkInTheTrunk.warning", new Object[]{this.mountPointUri(model), input.getPostambleLength()});
            logger.log(Level.FINE, "junkInTheTrunk.fine", ex);
        }
        return input;
    }

    public OptionOutputSocket getOutputSocket(FsController<?> controller, FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        if ((options = options.set((Enum)FsOutputOption.STORE)).get((Enum)FsOutputOption.GROW)) {
            options = options.set((Enum)FsOutputOption.APPEND).clear((Enum)FsOutputOption.CACHE);
        }
        return new OptionOutputSocket(controller.getOutputSocket(name, options, template), (BitField<FsOutputOption>)options);
    }

    public final OutputShop<ZipDriverEntry> newOutputShop(FsModel model, OutputSocket<?> output, InputShop<ZipDriverEntry> source) throws IOException {
        if (null == model) {
            throw new NullPointerException();
        }
        return this.newOutputShop0(model, (OptionOutputSocket)output, (ZipInputShop)source);
    }

    @CreatesObligation
    private OutputShop<ZipDriverEntry> newOutputShop0(FsModel model, OptionOutputSocket output, @CheckForNull @WillNotClose ZipInputShop source) throws IOException {
        BitField<FsOutputOption> options = output.getOptions();
        if (null != source) {
            source.setAppendee(options.get((Enum)FsOutputOption.GROW));
        }
        return this.newOutputShop(model, output, source);
    }

    @CreatesObligation
    protected OutputShop<ZipDriverEntry> newOutputShop(FsModel model, OptionOutputSocket output, @CheckForNull @WillNotClose ZipInputShop source) throws IOException {
        assert (null != model);
        OutputStream out = output.newOutputStream();
        try {
            return this.newOutputShop(model, out, source);
        }
        catch (IOException ex) {
            block5: {
                try {
                    out.close();
                }
                catch (IOException ex2) {
                    if (!JSE7.AVAILABLE) break block5;
                    ex.addSuppressed(ex2);
                }
            }
            throw ex;
        }
    }

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    protected OutputShop<ZipDriverEntry> newOutputShop(FsModel model, @WillCloseWhenClosed OutputStream out, @CheckForNull @WillNotClose ZipInputShop source) throws IOException {
        return new FsMultiplexedOutputShop((OutputShop)new ZipOutputShop(this, model, out, source), this.getPool());
    }
}

