/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.tar;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.archive.tar.TarDriver;
import de.schlichtherle.truezip.fs.archive.tar.TarInputShop;
import de.schlichtherle.truezip.fs.archive.tar.TarOutputShop;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;

@Immutable
public class TarBZip2Driver
extends TarDriver {
    public static final int BUFFER_SIZE = 8192;

    public TarBZip2Driver(IOPoolProvider provider) {
        super(provider);
    }

    public int getBufferSize() {
        return 8192;
    }

    public int getLevel() {
        return 9;
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsController<?> controller, FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return controller.getOutputSocket(name, options.set((Enum)FsOutputOption.STORE), template);
    }

    @Override
    protected TarInputShop newTarInputShop(FsModel model, InputStream in) throws IOException {
        return super.newTarInputShop(model, (InputStream)new BZip2CompressorInputStream((InputStream)new BufferedInputStream(in, this.getBufferSize())));
    }

    @Override
    protected TarOutputShop newTarOutputShop(FsModel model, OutputStream out, TarInputShop source) throws IOException {
        return super.newTarOutputShop(model, (OutputStream)((Object)new BZip2CompressorOutputStream(new BufferedOutputStream(out, this.getBufferSize()), this.getLevel())), source);
    }

    private static final class BZip2CompressorOutputStream
    extends org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream {
        final OutputStream out;

        BZip2CompressorOutputStream(OutputStream out, int level) throws IOException {
            super(out, level);
            this.out = out;
        }

        public void close() throws IOException {
            super.close();
            this.out.close();
        }
    }
}

