/*
 * Decompiled with CFR 0.152.
 */
package de.fuberlin.wiwiss.pubby.servlets;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import de.fuberlin.wiwiss.pubby.Configuration;
import de.fuberlin.wiwiss.pubby.HypermediaResource;
import de.fuberlin.wiwiss.pubby.MappedResource;
import de.fuberlin.wiwiss.pubby.ResourceDescription;
import de.fuberlin.wiwiss.pubby.servlets.BasePathServlet;
import de.fuberlin.wiwiss.pubby.servlets.VelocityHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.context.Context;

public class PathPageURLServlet
extends BasePathServlet {
    private static final long serialVersionUID = -2597664961896022667L;

    @Override
    public boolean doGet(HypermediaResource controller, Collection<MappedResource> resources, Property property, boolean isInverse, HttpServletRequest request, HttpServletResponse response, Configuration config) throws IOException {
        StmtIterator it;
        Model descriptions = this.getAnonymousPropertyValues(resources, property, isInverse);
        if (descriptions.size() == 0L) {
            return false;
        }
        Resource r = descriptions.getResource(controller.getAbsoluteIRI());
        ArrayList<ResourceDescription> resourceDescriptions = new ArrayList<ResourceDescription>();
        StmtIterator stmtIterator = it = isInverse ? descriptions.listStatements(null, property, (RDFNode)r) : r.listProperties(property);
        while (it.hasNext()) {
            Resource value;
            Statement stmt = it.nextStatement();
            Object object = value = isInverse ? stmt.getSubject() : stmt.getObject();
            if (!value.isAnon()) continue;
            resourceDescriptions.add(new ResourceDescription((Resource)value.as(Resource.class), descriptions, config));
        }
        Model description = this.getResourceDescription(resources);
        ResourceDescription resourceDescription = new ResourceDescription(controller, description, config);
        String title = resourceDescription.getLabel() + (isInverse ? " \u00ab " : " \u00bb ") + config.getPrefixes().getNsURIPrefix(property.getNameSpace()) + ":" + property.getLocalName();
        VelocityHelper template = new VelocityHelper(this.getServletContext(), response);
        Context context = template.getVelocityContext();
        context.put("project_name", (Object)config.getProjectName());
        context.put("project_link", (Object)config.getProjectLink());
        context.put("title", (Object)title);
        context.put("server_base", (Object)config.getWebApplicationBaseURI());
        context.put("sparql_endpoint", (Object)this.getFirstSPARQLEndpoint(resources));
        context.put("back_uri", (Object)controller.getAbsoluteIRI());
        context.put("back_label", (Object)resourceDescription.getLabel());
        context.put("rdf_link", (Object)(isInverse ? controller.getInversePathDataURL(property) : controller.getPathDataURL(property)));
        context.put("resources", resourceDescriptions);
        template.renderXHTML("pathpage.vm");
        return true;
    }
}

