/*
 * Decompiled with CFR 0.152.
 */
package de.fuberlin.wiwiss.pubby.servlets;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDFS;
import de.fuberlin.wiwiss.pubby.Configuration;
import de.fuberlin.wiwiss.pubby.HypermediaResource;
import de.fuberlin.wiwiss.pubby.MappedResource;
import de.fuberlin.wiwiss.pubby.ModelResponse;
import de.fuberlin.wiwiss.pubby.ResourceDescription;
import de.fuberlin.wiwiss.pubby.servlets.BasePathServlet;
import de.fuberlin.wiwiss.pubby.vocab.FOAF;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PathDataURLServlet
extends BasePathServlet {
    private static final long serialVersionUID = -7927775670218866340L;

    @Override
    public boolean doGet(HypermediaResource controller, Collection<MappedResource> resources, Property property, boolean isInverse, HttpServletRequest request, HttpServletResponse response, Configuration config) throws IOException {
        Model descriptions = this.getAnonymousPropertyValues(resources, property, isInverse);
        if (descriptions.size() == 0L) {
            return false;
        }
        if (descriptions.qnameFor(FOAF.primaryTopic.getURI()) == null && descriptions.getNsPrefixURI("foaf") == null) {
            descriptions.setNsPrefix("foaf", "http://xmlns.com/foaf/0.1/");
        }
        if (descriptions.qnameFor(RDFS.label.getURI()) == null && descriptions.getNsPrefixURI("rdfs") == null) {
            descriptions.setNsPrefix("rdfs", RDFS.getURI());
        }
        Resource r = descriptions.getResource(controller.getAbsoluteIRI());
        Resource document = descriptions.getResource(this.addQueryString(isInverse ? controller.getInversePathDataURL(property) : controller.getPathDataURL(property), request));
        document.addProperty(FOAF.primaryTopic, (RDFNode)r);
        String resourceLabel = new ResourceDescription(controller, descriptions, config).getLabel();
        String propertyLabel = config.getPrefixes().qnameFor(property.getURI());
        if (isInverse) {
            document.addProperty(RDFS.label, "RDF description of resources whose " + propertyLabel + " is " + resourceLabel);
        } else {
            document.addProperty(RDFS.label, "RDF description of resources that are " + propertyLabel + " of " + resourceLabel);
        }
        for (MappedResource resource : resources) {
            resource.getDataset().addDocumentMetadata(descriptions, document);
        }
        new ModelResponse(descriptions, request, response).serve();
        return true;
    }
}

