/*
 * Decompiled with CFR 0.152.
 */
package de.fuberlin.wiwiss.pubby;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IRIEncoder {
    private static final Pattern percentEncoding = Pattern.compile("(%[0-9a-fA-F][0-9a-fA-F])+");
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String toIRI(String uri) {
        StringBuffer decoded = new StringBuffer();
        Matcher matcher = percentEncoding.matcher(uri);
        while (matcher.find()) {
            matcher.appendReplacement(decoded, IRIEncoder.decode(matcher.group()));
        }
        matcher.appendTail(decoded);
        return decoded.toString();
    }

    public static String toURI(String iri) {
        try {
            StringBuffer encoded = new StringBuffer();
            for (int i = 0; i < iri.length(); ++i) {
                if (iri.charAt(i) <= '\u0080') {
                    encoded.append(iri.charAt(i));
                    continue;
                }
                for (byte b : iri.substring(i, i + 1).getBytes("utf-8")) {
                    IRIEncoder.appendOctet(encoded, b);
                }
            }
            return encoded.toString();
        }
        catch (UnsupportedEncodingException ex) {
            return iri;
        }
    }

    private static String decode(String percentEncoded) {
        StringBuffer decoded = new StringBuffer();
        int[] octets = IRIEncoder.toBytes(percentEncoded);
        int i = 0;
        while (i < octets.length) {
            if (octets[i] <= 127) {
                if (IRIEncoder.isUnreservedASCII((char)octets[i])) {
                    decoded.append((char)octets[i]);
                } else {
                    IRIEncoder.appendOctet(decoded, (byte)octets[i]);
                }
                ++i;
                continue;
            }
            if (IRIEncoder.isContinuationOctet(octets[i])) {
                IRIEncoder.appendOctet(decoded, (byte)octets[i]);
                ++i;
                continue;
            }
            int bytesInSequence = IRIEncoder.getBytesInSequence(octets[i]);
            if (i + bytesInSequence > octets.length) {
                IRIEncoder.appendOctet(decoded, (byte)octets[i]);
                ++i;
                continue;
            }
            boolean enoughContinuationBytes = true;
            for (int j = 1; j < bytesInSequence; ++j) {
                if (IRIEncoder.isContinuationOctet(octets[i + j])) continue;
                enoughContinuationBytes = false;
                break;
            }
            if (!enoughContinuationBytes) {
                IRIEncoder.appendOctet(decoded, (byte)octets[i]);
                ++i;
                continue;
            }
            decoded.append(IRIEncoder.toCharacter(octets, i, bytesInSequence));
            i += bytesInSequence;
        }
        return decoded.toString();
    }

    private static boolean isContinuationOctet(int octet) {
        return (octet & 0xC0) == 128;
    }

    private static void appendOctet(StringBuffer sb, byte octet) {
        sb.append('%');
        sb.append(hexDigits[octet >> 4 & 0xF]);
        sb.append(hexDigits[octet & 0xF]);
    }

    private static int getBytesInSequence(int octet) {
        if ((octet & 0x80) == 0) {
            return 1;
        }
        if ((octet & 0xC0) == 128) {
            return 0;
        }
        if ((octet & 0xE0) == 192) {
            return 2;
        }
        if ((octet & 0xF0) == 224) {
            return 3;
        }
        if ((octet & 0xF8) == 240) {
            return 4;
        }
        if ((octet & 0xFC) == 248) {
            return 5;
        }
        if ((octet & 0xFE) == 252) {
            return 6;
        }
        return 0;
    }

    private static char toCharacter(int[] octets, int offset, int length) {
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)octets[offset + i];
        }
        try {
            return new String(bytes, "utf-8").charAt(0);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static boolean isUnreservedASCII(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '.' || c == '_' || c == '~';
    }

    private static int[] toBytes(String percentEncoded) {
        int length = percentEncoded.length() / 3;
        int[] result = new int[length];
        for (int i = 0; i < length; ++i) {
            result[i] = IRIEncoder.toByte(percentEncoded.charAt(i * 3 + 1), percentEncoded.charAt(i * 3 + 2));
        }
        return result;
    }

    private static int toByte(char hex1, char hex2) {
        return IRIEncoder.toByte(hex1) << 4 | IRIEncoder.toByte(hex2);
    }

    private static int toByte(char hex) {
        if (hex >= '0' && hex <= '9') {
            return hex - 48;
        }
        if (hex >= 'a' && hex <= 'f') {
            return hex - 97 + 10;
        }
        if (hex >= 'A' && hex <= 'F') {
            return hex - 65 + 10;
        }
        throw new IllegalArgumentException("Not a hex digit: " + hex);
    }
}

