/*
 * Decompiled with CFR 0.152.
 */
package de.fuberlin.wiwiss.pubby;

import com.hp.hpl.jena.rdf.model.Property;
import de.fuberlin.wiwiss.pubby.Configuration;

public class HypermediaResource {
    private final String relativeIRI;
    private final Configuration config;

    public HypermediaResource(String relativeIRI, Configuration config) {
        this.relativeIRI = relativeIRI;
        this.config = config;
    }

    public String getRelativeIRI() {
        return this.relativeIRI;
    }

    public String getAbsoluteIRI() {
        return this.config.getWebApplicationBaseURI() + this.config.getWebResourcePrefix() + this.relativeIRI;
    }

    public String getPageURL() {
        return this.config.getWebApplicationBaseURI() + "page/" + this.relativeIRI;
    }

    public String getDataURL() {
        return this.config.getWebApplicationBaseURI() + "data/" + this.relativeIRI;
    }

    public String getPathPageURL(Property property) {
        return this.getPathURL("pathpage/", property);
    }

    public String getPathDataURL(Property property) {
        return this.getPathURL("pathdata/", property);
    }

    public String getInversePathPageURL(Property property) {
        return this.getPathURL("pathpage/-", property);
    }

    public String getInversePathDataURL(Property property) {
        return this.getPathURL("pathdata/-", property);
    }

    private String getPathURL(String urlPrefix, Property property) {
        if (this.config.getPrefixes().qnameFor(property.getURI()) == null) {
            return null;
        }
        return this.config.getWebApplicationBaseURI() + urlPrefix + this.config.getPrefixes().qnameFor(property.getURI()) + "/" + this.relativeIRI;
    }
}

