/*
 * Decompiled with CFR 0.152.
 */
package de.fuberlin.wiwiss.pubby.servlets;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import de.fuberlin.wiwiss.pubby.Configuration;
import de.fuberlin.wiwiss.pubby.MappedResource;
import de.fuberlin.wiwiss.pubby.ResourceDescription;
import de.fuberlin.wiwiss.pubby.servlets.BaseURLServlet;
import de.fuberlin.wiwiss.pubby.servlets.VelocityHelper;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class PageURLServlet
extends BaseURLServlet {
    public boolean doGet(MappedResource resource, HttpServletRequest request, HttpServletResponse response, Configuration config) throws ServletException, IOException {
        Model description = this.getResourceDescription(resource);
        if (description.size() == 0L) {
            return false;
        }
        Velocity.setProperty((String)"velocimacro.context.localscope", (Object)Boolean.TRUE);
        ResourceDescription resourceDescription = new ResourceDescription(resource, description, config);
        String discoLink = "http://www4.wiwiss.fu-berlin.de/rdf_browser/?browse_uri=" + URLEncoder.encode(resource.getWebURI(), "utf-8");
        String tabulatorLink = "http://dig.csail.mit.edu/2005/ajar/ajaw/tab.html?uri=" + URLEncoder.encode(resource.getWebURI(), "utf-8");
        String openLinkLink = "http://demo.openlinksw.com/rdfbrowser/?uri=" + URLEncoder.encode(resource.getWebURI(), "utf-8");
        VelocityHelper template = new VelocityHelper(this.getServletContext(), response);
        Context context = template.getVelocityContext();
        context.put("project_name", (Object)config.getProjectName());
        context.put("project_link", (Object)config.getProjectLink());
        context.put("uri", (Object)resourceDescription.getURI());
        context.put("server_base", (Object)config.getWebApplicationBaseURI());
        context.put("rdf_link", (Object)resource.getDataURL());
        context.put("disco_link", (Object)discoLink);
        context.put("tabulator_link", (Object)tabulatorLink);
        context.put("openlink_link", (Object)openLinkLink);
        context.put("sparql_endpoint", (Object)resource.getDataset().getDataSource().getEndpointURL());
        context.put("title", (Object)resourceDescription.getLabel());
        context.put("comment", (Object)resourceDescription.getComment());
        context.put("image", (Object)resourceDescription.getImageURL());
        context.put("properties", (Object)resourceDescription.getProperties());
        try {
            Model metadata = ModelFactory.createDefaultModel();
            Resource documentRepresentation = resource.getDataset().addMetadataFromTemplate(metadata, resource, this.getServletContext());
            context.put("metadata", (Object)documentRepresentation);
            Map nsSet = metadata.getNsPrefixMap();
            nsSet.putAll(description.getNsPrefixMap());
            context.put("prefixes", nsSet.entrySet());
            context.put("blankNodesMap", new HashMap());
        }
        catch (Exception e) {
            context.put("metadata", (Object)Boolean.FALSE);
        }
        template.renderXHTML("page.vm");
        return true;
    }
}

