/*
 * Decompiled with CFR 0.152.
 */
package de.fuberlin.wiwiss.pubby.negotiation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MediaRangeSpec {
    private static final Pattern tokenPattern;
    private static final Pattern parameterPattern;
    private static final Pattern mediaRangePattern;
    private static final Pattern qValuePattern;
    private final String type;
    private final String subtype;
    private final List parameterNames;
    private final List parameterValues;
    private final String mediaType;
    private final double quality;

    public static MediaRangeSpec parseType(String mediaType) {
        MediaRangeSpec m = MediaRangeSpec.parseRange(mediaType);
        if (m == null || m.isWildcardType() || m.isWildcardSubtype()) {
            return null;
        }
        return m;
    }

    public static MediaRangeSpec parseRange(String mediaRange) {
        Matcher m = mediaRangePattern.matcher(mediaRange);
        if (!m.matches()) {
            return null;
        }
        String type = m.group(1).toLowerCase();
        String subtype = m.group(2).toLowerCase();
        String unparsedParameters = m.group(3);
        String qValue = m.group(7);
        m = parameterPattern.matcher(unparsedParameters);
        if ("*".equals(type) && !"*".equals(subtype)) {
            return null;
        }
        ArrayList<String> parameterNames = new ArrayList<String>();
        ArrayList<String> parameterValues = new ArrayList<String>();
        while (m.find()) {
            String name = m.group(1).toLowerCase();
            String value = m.group(3) == null ? m.group(2) : MediaRangeSpec.unescape(m.group(3));
            parameterNames.add(name);
            parameterValues.add(value);
        }
        double quality = 1.0;
        if (qValue != null && qValuePattern.matcher(qValue).matches()) {
            try {
                quality = Double.parseDouble(qValue);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return new MediaRangeSpec(type, subtype, parameterNames, parameterValues, quality);
    }

    public static List parseAccept(String s) {
        ArrayList<MediaRangeSpec> result = new ArrayList<MediaRangeSpec>();
        Matcher m = mediaRangePattern.matcher(s);
        while (m.find()) {
            result.add(MediaRangeSpec.parseRange(m.group()));
        }
        return result;
    }

    private static String unescape(String s) {
        return s.replaceAll("\\\\(.)", "$1");
    }

    private static String escape(String s) {
        return s.replaceAll("[\\\\\"]", "\\\\$0");
    }

    private MediaRangeSpec(String type, String subtype, List parameterNames, List parameterValues, double quality) {
        this.type = type;
        this.subtype = subtype;
        this.parameterNames = Collections.unmodifiableList(parameterNames);
        this.parameterValues = parameterValues;
        this.mediaType = this.buildMediaType();
        this.quality = quality;
    }

    private String buildMediaType() {
        StringBuffer result = new StringBuffer();
        result.append(this.type);
        result.append("/");
        result.append(this.subtype);
        for (int i = 0; i < this.parameterNames.size(); ++i) {
            result.append(";");
            result.append(this.parameterNames.get(i));
            result.append("=");
            String value = (String)this.parameterValues.get(i);
            if (tokenPattern.matcher(value).matches()) {
                result.append(value);
                continue;
            }
            result.append("\"");
            result.append(MediaRangeSpec.escape(value));
            result.append("\"");
        }
        return result.toString();
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public List getParameterNames() {
        return this.parameterNames;
    }

    public String getParameter(String parameterName) {
        for (int i = 0; i < this.parameterNames.size(); ++i) {
            if (!this.parameterNames.get(i).equals(parameterName.toLowerCase())) continue;
            return (String)this.parameterValues.get(i);
        }
        return null;
    }

    public boolean isWildcardType() {
        return "*".equals(this.type);
    }

    public boolean isWildcardSubtype() {
        return !this.isWildcardType() && "*".equals(this.subtype);
    }

    public double getQuality() {
        return this.quality;
    }

    public int getPrecedence(MediaRangeSpec range) {
        if (range.isWildcardType()) {
            return 1;
        }
        if (!range.type.equals(this.type)) {
            return 0;
        }
        if (range.isWildcardSubtype()) {
            return 2;
        }
        if (!range.subtype.equals(this.subtype)) {
            return 0;
        }
        if (range.getParameterNames().isEmpty()) {
            return 3;
        }
        int result = 3;
        for (int i = 0; i < range.getParameterNames().size(); ++i) {
            String name = (String)range.getParameterNames().get(i);
            String value = range.getParameter(name);
            if (!value.equals(this.getParameter(name))) {
                return 0;
            }
            ++result;
        }
        return result;
    }

    public MediaRangeSpec getBestMatch(List mediaRanges) {
        MediaRangeSpec result = null;
        int bestPrecedence = 0;
        Iterator it = mediaRanges.iterator();
        while (it.hasNext()) {
            MediaRangeSpec range = (MediaRangeSpec)it.next();
            if (this.getPrecedence(range) <= bestPrecedence) continue;
            bestPrecedence = this.getPrecedence(range);
            result = range;
        }
        return result;
    }

    public String toString() {
        return this.mediaType + ";q=" + this.quality;
    }

    static {
        String token = "[\\x20-\\x7E&&[^()<>@,;:\\\"/\\[\\]?={} ]]+";
        String quotedString = "\"((?:[\\x20-\\x7E\\n\\r\\t&&[^\"\\\\]]|\\\\[\\x00-\\x7F])*)\"";
        String parameter = ";\\s*(?!q\\s*=)(" + token + ")=(?:(" + token + ")|" + quotedString + ")";
        String qualityValue = "(?:0(?:\\.\\d{0,3})?|1(?:\\.0{0,3})?)";
        String quality = ";\\s*q\\s*=\\s*([^;,]*)";
        String regex = "(" + token + ")/(" + token + ")" + "((?:\\s*" + parameter + ")*)" + "(?:\\s*" + quality + ")?" + "((?:\\s*" + parameter + ")*)";
        tokenPattern = Pattern.compile(token);
        parameterPattern = Pattern.compile(parameter);
        mediaRangePattern = Pattern.compile(regex);
        qValuePattern = Pattern.compile(qualityValue);
    }
}

