/*
 * Decompiled with CFR 0.152.
 */
package de.fuberlin.wiwiss.pubby.negotiation;

import de.fuberlin.wiwiss.pubby.negotiation.MediaRangeSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class ContentTypeNegotiator {
    private List variantSpecs = new ArrayList();
    private List defaultAcceptRanges = Collections.singletonList(MediaRangeSpec.parseRange("*/*"));
    private Collection userAgentOverrides = new ArrayList();

    public VariantSpec addVariant(String mediaType) {
        VariantSpec result = new VariantSpec(mediaType);
        this.variantSpecs.add(result);
        return result;
    }

    public void setDefaultAccept(String accept) {
        this.defaultAcceptRanges = MediaRangeSpec.parseAccept(accept);
    }

    public void addUserAgentOverride(Pattern userAgentString, String originalAcceptHeader, String newAcceptHeader) {
        this.userAgentOverrides.add(new AcceptHeaderOverride(userAgentString, originalAcceptHeader, newAcceptHeader));
    }

    public MediaRangeSpec getBestMatch(String accept) {
        return this.getBestMatch(accept, null);
    }

    public MediaRangeSpec getBestMatch(String accept, String userAgent) {
        if (userAgent == null) {
            userAgent = "";
        }
        Iterator it = this.userAgentOverrides.iterator();
        String overriddenAccept = accept;
        while (it.hasNext()) {
            AcceptHeaderOverride override = (AcceptHeaderOverride)it.next();
            if (!override.matches(accept, userAgent)) continue;
            overriddenAccept = override.getReplacement();
        }
        return new Negotiation(this.toAcceptRanges(overriddenAccept)).negotiate();
    }

    private List toAcceptRanges(String accept) {
        if (accept == null) {
            return this.defaultAcceptRanges;
        }
        List result = MediaRangeSpec.parseAccept(accept);
        if (result.isEmpty()) {
            return this.defaultAcceptRanges;
        }
        return result;
    }

    private class AcceptHeaderOverride {
        private Pattern userAgentPattern;
        private String original;
        private String replacement;

        AcceptHeaderOverride(Pattern userAgentPattern, String original, String replacement) {
            this.userAgentPattern = userAgentPattern;
            this.original = original;
            this.replacement = replacement;
        }

        boolean matches(String acceptHeader) {
            return this.matches(acceptHeader, null);
        }

        boolean matches(String acceptHeader, String userAgentHeader) {
            return !(this.userAgentPattern != null && !this.userAgentPattern.matcher(userAgentHeader).find() || this.original != null && !this.original.equals(acceptHeader));
        }

        String getReplacement() {
            return this.replacement;
        }
    }

    private class Negotiation {
        private final List ranges;
        private MediaRangeSpec bestMatchingVariant = null;
        private MediaRangeSpec bestDefaultVariant = null;
        private double bestMatchingQuality = 0.0;
        private double bestDefaultQuality = 0.0;

        Negotiation(List ranges) {
            this.ranges = ranges;
        }

        MediaRangeSpec negotiate() {
            Iterator it = ContentTypeNegotiator.this.variantSpecs.iterator();
            while (it.hasNext()) {
                VariantSpec variant = (VariantSpec)it.next();
                if (variant.isDefault) {
                    this.evaluateDefaultVariant(variant.getMediaType());
                }
                this.evaluateVariant(variant.getMediaType());
                Iterator aliasIt = variant.getAliases().iterator();
                while (aliasIt.hasNext()) {
                    MediaRangeSpec alias = (MediaRangeSpec)aliasIt.next();
                    this.evaluateVariantAlias(alias, variant.getMediaType());
                }
            }
            return this.bestMatchingVariant == null ? this.bestDefaultVariant : this.bestMatchingVariant;
        }

        private void evaluateVariantAlias(MediaRangeSpec variant, MediaRangeSpec isAliasFor) {
            if (variant.getBestMatch(this.ranges) == null) {
                return;
            }
            double q = variant.getBestMatch(this.ranges).getQuality();
            if (q * variant.getQuality() > this.bestMatchingQuality) {
                this.bestMatchingVariant = isAliasFor;
                this.bestMatchingQuality = q * variant.getQuality();
            }
        }

        private void evaluateVariant(MediaRangeSpec variant) {
            this.evaluateVariantAlias(variant, variant);
        }

        private void evaluateDefaultVariant(MediaRangeSpec variant) {
            if (variant.getQuality() > this.bestDefaultQuality) {
                this.bestDefaultVariant = variant;
                this.bestDefaultQuality = 1.0E-5 * variant.getQuality();
            }
        }
    }

    public class VariantSpec {
        private MediaRangeSpec type;
        private List aliases = new ArrayList();
        private boolean isDefault = false;

        public VariantSpec(String mediaType) {
            this.type = MediaRangeSpec.parseType(mediaType);
        }

        public VariantSpec addAliasMediaType(String mediaType) {
            this.aliases.add(MediaRangeSpec.parseType(mediaType));
            return this;
        }

        public void makeDefault() {
            this.isDefault = true;
        }

        public MediaRangeSpec getMediaType() {
            return this.type;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public List getAliases() {
            return this.aliases;
        }
    }
}

