/*
 * Decompiled with CFR 0.152.
 */
package de.fuberlin.wiwiss.pubby;

import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.shared.PrefixMapping;
import java.util.Iterator;
import java.util.Map;

public class URIPrefixer {
    private final Resource resource;
    private final String prefix;
    private final String localName;

    public URIPrefixer(String uri, PrefixMapping prefixes) {
        this(ResourceFactory.createResource((String)uri), prefixes);
    }

    public URIPrefixer(Resource resource, PrefixMapping prefixes) {
        this.resource = resource;
        String uri = resource.getURI();
        Iterator it = prefixes.getNsPrefixMap().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String entryPrefix = (String)entry.getKey();
            String entryURI = (String)entry.getValue();
            if (!uri.startsWith(entryURI)) continue;
            this.prefix = entryPrefix;
            this.localName = uri.substring(entryURI.length());
            return;
        }
        this.prefix = null;
        this.localName = null;
    }

    public boolean hasPrefix() {
        return this.prefix != null;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getLocalName() {
        if (this.localName == null) {
            return this.resource.getLocalName();
        }
        return this.localName;
    }

    public String toTurtle() {
        if (this.hasPrefix()) {
            return this.getPrefix() + ":" + this.getLocalName();
        }
        return "<" + this.resource.getURI() + ">";
    }
}

