/*
 * Decompiled with CFR 0.152.
 */
package de.fuberlin.wiwiss.pubby;

import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.vocabulary.XSD;
import de.fuberlin.wiwiss.pubby.Configuration;
import de.fuberlin.wiwiss.pubby.DataSource;
import de.fuberlin.wiwiss.pubby.MappedResource;
import de.fuberlin.wiwiss.pubby.ModelDataSource;
import de.fuberlin.wiwiss.pubby.RemoteSPARQLDataSource;
import de.fuberlin.wiwiss.pubby.vocab.CONF;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;

public class Dataset {
    private final Model model;
    private final Resource config;
    private final DataSource dataSource;
    private final Pattern datasetURIPattern;
    private final char[] fixUnescapeCharacters;
    private final Resource rdfDocumentMetadataTemplate;
    private final String metadataTemplate;
    private static final String metadataPlaceholderURIPrefix = "about:metadata:";
    private Calendar currentTime;
    private Resource currentDocRepr;
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$Resource;

    public Dataset(Resource config) {
        this.model = config.getModel();
        this.config = config;
        this.datasetURIPattern = config.hasProperty(CONF.datasetURIPattern) ? Pattern.compile(config.getProperty(CONF.datasetURIPattern).getString()) : Pattern.compile(".*");
        if (config.hasProperty(CONF.fixUnescapedCharacters)) {
            String chars = config.getProperty(CONF.fixUnescapedCharacters).getString();
            this.fixUnescapeCharacters = new char[chars.length()];
            for (int i = 0; i < chars.length(); ++i) {
                this.fixUnescapeCharacters[i] = chars.charAt(i);
            }
        } else {
            this.fixUnescapeCharacters = new char[0];
        }
        this.rdfDocumentMetadataTemplate = config.hasProperty(CONF.rdfDocumentMetadata) ? config.getProperty(CONF.rdfDocumentMetadata).getResource() : null;
        this.metadataTemplate = config.hasProperty(CONF.metadataTemplate) ? config.getProperty(CONF.metadataTemplate).getString() : null;
        if (config.hasProperty(CONF.sparqlEndpoint)) {
            String endpointURL = config.getProperty(CONF.sparqlEndpoint).getResource().getURI();
            String defaultGraph = config.hasProperty(CONF.sparqlDefaultGraph) ? config.getProperty(CONF.sparqlDefaultGraph).getResource().getURI() : null;
            this.dataSource = new RemoteSPARQLDataSource(endpointURL, defaultGraph);
        } else {
            Model data = ModelFactory.createDefaultModel();
            StmtIterator it = config.listProperties(CONF.loadRDF);
            while (it.hasNext()) {
                Statement stmt = it.nextStatement();
                FileManager.get().readModel(data, stmt.getResource().getURI());
            }
            this.dataSource = new ModelDataSource(data);
        }
    }

    public boolean isDatasetURI(String uri) {
        return uri.startsWith(this.getDatasetBase()) && this.datasetURIPattern.matcher(uri.substring(this.getDatasetBase().length())).matches();
    }

    public MappedResource getMappedResourceFromDatasetURI(String datasetURI, Configuration configuration) {
        return new MappedResource(this.escapeURIDelimiters(datasetURI.substring(this.getDatasetBase().length())), datasetURI, configuration, this);
    }

    public MappedResource getMappedResourceFromRelativeWebURI(String relativeWebURI, boolean isResourceURI, Configuration configuration) {
        if (isResourceURI && !"".equals(this.getWebResourcePrefix())) {
            if (!relativeWebURI.startsWith(this.getWebResourcePrefix())) {
                return null;
            }
            relativeWebURI = relativeWebURI.substring(this.getWebResourcePrefix().length());
        }
        if (!this.datasetURIPattern.matcher(relativeWebURI = this.fixUnescapedCharacters(relativeWebURI)).matches()) {
            return null;
        }
        return new MappedResource(relativeWebURI, this.getDatasetBase() + this.unescapeURIDelimiters(relativeWebURI), configuration, this);
    }

    public String getDatasetBase() {
        return this.config.getProperty(CONF.datasetBase).getResource().getURI();
    }

    public boolean getAddSameAsStatements() {
        return this.getBooleanConfigValue(CONF.addSameAsStatements, false);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public boolean redirectRDFRequestsToEndpoint() {
        return this.getBooleanConfigValue(CONF.redirectRDFRequestsToEndpoint, false);
    }

    public String getWebResourcePrefix() {
        if (this.config.hasProperty(CONF.webResourcePrefix)) {
            return this.config.getProperty(CONF.webResourcePrefix).getString();
        }
        return "";
    }

    public void addDocumentMetadata(Model document, Resource documentResource) {
        Statement stmt;
        if (this.rdfDocumentMetadataTemplate == null) {
            return;
        }
        StmtIterator it = this.rdfDocumentMetadataTemplate.listProperties();
        while (it.hasNext()) {
            stmt = it.nextStatement();
            document.add(documentResource, stmt.getPredicate(), stmt.getObject());
        }
        it = this.model.listStatements(null, null, (RDFNode)this.rdfDocumentMetadataTemplate);
        while (it.hasNext()) {
            stmt = it.nextStatement();
            if (stmt.getPredicate().equals(CONF.rdfDocumentMetadata)) continue;
            document.add(stmt.getSubject(), stmt.getPredicate(), (RDFNode)documentResource);
        }
    }

    public Resource addMetadataFromTemplate(Model document, MappedResource describedResource, ServletContext context) {
        if (this.metadataTemplate == null) {
            return null;
        }
        this.currentTime = Calendar.getInstance();
        Model tplModel = ModelFactory.createDefaultModel();
        String tplPath = context.getRealPath("/") + "/WEB-INF/templates/" + this.metadataTemplate;
        FileManager.get().readModel(tplModel, tplPath, FileUtils.guessLang((String)tplPath, (String)"N3"));
        Model metadata = ModelFactory.createDefaultModel();
        this.currentDocRepr = metadata.createResource();
        StmtIterator it = tplModel.listStatements();
        while (it.hasNext()) {
            Statement stmt = it.nextStatement();
            Resource subj = stmt.getSubject();
            Property pred = stmt.getPredicate();
            RDFNode obj = stmt.getObject();
            try {
                if (subj.toString().contains(metadataPlaceholderURIPrefix) && (subj = (Resource)this.parsePlaceholder((RDFNode)subj, describedResource, context)) == null) {
                    subj = this.model.createResource(new AnonId(String.valueOf(stmt.getSubject().hashCode())));
                }
                if (obj.toString().contains(metadataPlaceholderURIPrefix)) {
                    obj = this.parsePlaceholder(obj, describedResource, context);
                }
                if (obj == null) continue;
                stmt = metadata.createStatement(subj, pred, obj);
                metadata.add(stmt);
            }
            catch (Exception e) {
                metadata.remove(stmt);
                e.printStackTrace();
            }
        }
        boolean changes = true;
        while (changes) {
            changes = false;
            StmtIterator stmtIt = metadata.listStatements();
            ArrayList<Statement> remList = new ArrayList<Statement>();
            while (stmtIt.hasNext()) {
                Statement s = stmtIt.nextStatement();
                if (!s.getObject().isAnon() || ((Resource)s.getObject().as(class$com$hp$hpl$jena$rdf$model$Resource == null ? Dataset.class$("com.hp.hpl.jena.rdf.model.Resource") : class$com$hp$hpl$jena$rdf$model$Resource)).listProperties().hasNext()) continue;
                remList.add(s);
                changes = true;
            }
            metadata.remove(remList);
        }
        if (document != null) {
            document.add(metadata);
        }
        return this.currentDocRepr;
    }

    private RDFNode parsePlaceholder(RDFNode phRes, MappedResource describedResource, ServletContext context) {
        Resource globalConfig;
        Statement ptrStmt;
        StmtIterator it;
        Property p;
        String phURI = phRes.asNode().getURI();
        phURI = phURI.replace(metadataPlaceholderURIPrefix, "");
        String phPackage = phURI.substring(0, phURI.indexOf(":") + 1);
        String phName = phURI.replace(phPackage, "");
        if ((phPackage = phPackage.replace(":", "")).equals("runtime")) {
            if (phName.equals("query")) {
                RemoteSPARQLDataSource ds = (RemoteSPARQLDataSource)describedResource.getDataset().getDataSource();
                return this.model.createTypedLiteral(ds.getPreviousDescribeQuery());
            }
            if (phName.equals("time")) {
                return this.model.createTypedLiteral(this.currentTime);
            }
            if (phName.equals("graph")) {
                return this.currentDocRepr;
            }
            if (phName.equals("data")) {
                return this.model.createResource(describedResource.getDataURL());
            }
            if (phName.equals("resource")) {
                return this.model.createResource(describedResource.getWebURI());
            }
        }
        if (phPackage.equals("config")) {
            p = this.model.createProperty("http://richard.cyganiak.de/2007/pubby/config.rdf#" + phName);
            if (this.config.hasProperty(p)) {
                return this.config.getProperty(p).getObject();
            }
            it = this.config.getModel().listStatements(null, CONF.dataset, (RDFNode)this.config);
            ptrStmt = it.nextStatement();
            if (ptrStmt == null) {
                return null;
            }
            globalConfig = ptrStmt.getSubject();
            if (globalConfig.hasProperty(p)) {
                return globalConfig.getProperty(p).getObject();
            }
        }
        if (phPackage.equals("metadata")) {
            p = this.model.createProperty("http://example.org/metadata#" + phName);
            if (this.config.hasProperty(p)) {
                return this.config.getProperty(p).getObject();
            }
            it = this.config.getModel().listStatements(null, CONF.dataset, (RDFNode)this.config);
            ptrStmt = it.nextStatement();
            if (ptrStmt == null) {
                return null;
            }
            globalConfig = ptrStmt.getSubject();
            if (globalConfig.hasProperty(p)) {
                return globalConfig.getProperty(p).getObject();
            }
        }
        return this.model.createResource(new AnonId(String.valueOf(phRes.hashCode())));
    }

    private boolean getBooleanConfigValue(Property property, boolean defaultValue) {
        if (!this.config.hasProperty(property)) {
            return defaultValue;
        }
        Literal value = this.config.getProperty(property).getLiteral();
        if (XSD.xboolean.equals(value.getDatatype())) {
            return value.getBoolean();
        }
        return "true".equals(value.getString());
    }

    private String fixUnescapedCharacters(String uri) {
        if (this.fixUnescapeCharacters.length == 0) {
            return uri;
        }
        StringBuffer encoded = new StringBuffer(uri.length() + 4);
        for (int charIndex = 0; charIndex < uri.length(); ++charIndex) {
            boolean encodeThis = false;
            if (uri.charAt(charIndex) > '\u007f') {
                encodeThis = true;
            }
            for (int i = 0; i < this.fixUnescapeCharacters.length; ++i) {
                if (uri.charAt(charIndex) != this.fixUnescapeCharacters[i]) continue;
                encodeThis = true;
                break;
            }
            if (encodeThis) {
                encoded.append('%');
                char b = uri.charAt(charIndex);
                encoded.append(Integer.toString(b, 16).toUpperCase());
                continue;
            }
            encoded.append(uri.charAt(charIndex));
        }
        return encoded.toString();
    }

    private String escapeURIDelimiters(String uri) {
        return uri.replaceAll("#", "%23").replaceAll("\\?", "%3F");
    }

    private String unescapeURIDelimiters(String uri) {
        return uri.replaceAll("%23", "#").replaceAll("%3F", "?");
    }
}

