/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.nodegen;

import de.fau.cs.osr.ptk.common.AstVisitor;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import de.fau.cs.osr.ptk.common.ast.Text;
import de.fau.cs.osr.ptk.nodegen.AstNodeSpec;
import de.fau.cs.osr.ptk.nodegen.ParseException;
import de.fau.cs.osr.ptk.nodegen.parser.NameValue;
import de.fau.cs.osr.ptk.nodegen.parser.Section;

public final class AstNodeSpecVisitor
extends AstVisitor {
    private final AstNodeSpec astNodeSpec;

    public AstNodeSpecVisitor(AstNodeSpec astNodeSpec) {
        this.astNodeSpec = astNodeSpec;
    }

    public AstNodeSpec getAstNodeSpec() {
        return this.astNodeSpec;
    }

    protected Object visitNotFound(AstNode node) {
        throw new ParseException("syntax error: unexpected `%s'.", node, new Object[]{node.toString()});
    }

    public void visit(NodeList n) {
        this.iterate((AstNode)n);
    }

    public void visit(NameValue n) {
        String name = n.getName();
        if (this.astNodeSpec.getNodeName() == null && name.equals("Name")) {
            this.astNodeSpec.setNodeName(n.getValue());
        } else if (this.astNodeSpec.getClassExtends() == null && name.equals("Extends")) {
            this.astNodeSpec.setClassExtends(n.getValue());
        } else if (this.astNodeSpec.getNodeType() == null && name.equals("NodeType")) {
            this.astNodeSpec.setNodeType(n.getValue());
        } else if (name.equals("Implements")) {
            this.astNodeSpec.getClassImplements().add(n.getValue());
        } else if (name.equals("Constructor")) {
            this.astNodeSpec.getConstructors().add(n.getValue());
        } else if (name.equals("Import")) {
            this.astNodeSpec.getImports().add(n.getValue());
        } else {
            throw new ParseException("unsupported field `%s'.", (AstNode)n, new Object[]{name});
        }
    }

    public void visit(Section n) {
        String name = n.getTitle();
        if (name.equals("Properties")) {
            new AstNodeSpecPropertiesVisitor().go(n.getBody());
        } else if (name.equals("Children")) {
            new AstNodeSpecChildrenVisitor().go(n.getBody());
        } else if (name.equals("Header")) {
            new AstNodeSpecHeaderVisitor().go(n.getBody());
        } else if (name.equals("Body")) {
            new AstNodeSpecBodyVisitor().go(n.getBody());
        } else {
            throw new ParseException("unsupported section `%s'.", (AstNode)n, new Object[]{name});
        }
    }

    public final class AstNodeSpecBodyVisitor
    extends AstVisitor {
        public Object visitNotFound(AstNode node) {
            throw new ParseException("syntax error: unexpected `%s'.", node, new Object[]{node.getClass().getSimpleName()});
        }

        public void visit(Text n) {
            if (AstNodeSpecVisitor.this.astNodeSpec.getExtraBody() != null) {
                throw new ParseException("Multiple body sections are not allowed!", new Object[0]);
            }
            AstNodeSpecVisitor.this.astNodeSpec.setExtraBody(n.getContent());
        }
    }

    public final class AstNodeSpecHeaderVisitor
    extends AstVisitor {
        public Object visitNotFound(AstNode node) {
            throw new ParseException("syntax error: unexpected `%s'.", node, new Object[]{node.getClass().getSimpleName()});
        }

        public void visit(Text n) {
            if (AstNodeSpecVisitor.this.astNodeSpec.getExtraHeader() != null) {
                throw new ParseException("Multiple header sections are not allowed!", new Object[0]);
            }
            AstNodeSpecVisitor.this.astNodeSpec.setExtraHeader(n.getContent());
        }
    }

    public final class AstNodeSpecChildrenVisitor
    extends AstVisitor {
        public Object visitNotFound(AstNode node) {
            throw new ParseException("syntax error: unexpected `%s'.", node, new Object[]{node.getClass().getSimpleName()});
        }

        public void visit(NodeList n) {
            this.iterate((AstNode)n);
        }

        public void visit(NameValue n) {
            AstNodeSpecVisitor.this.astNodeSpec.getChildren().add(n);
        }
    }

    public final class AstNodeSpecPropertiesVisitor
    extends AstVisitor {
        public Object visitNotFound(AstNode node) {
            throw new ParseException("syntax error: unexpected `%s'.", node, new Object[]{node.getClass().getSimpleName()});
        }

        public void visit(NodeList n) {
            this.iterate((AstNode)n);
        }

        public void visit(NameValue n) {
            AstNodeSpecVisitor.this.astNodeSpec.getProperties().add(n);
        }
    }
}

