/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.nodegen;

import de.fau.cs.osr.ptk.nodegen.AstNodeSpec;
import de.fau.cs.osr.ptk.nodegen.MavenProjectProxy;
import de.fau.cs.osr.ptk.nodegen.ParseException;
import de.fau.cs.osr.ptk.nodegen.RatsDocGrammarVisitor;
import de.fau.cs.osr.ptk.nodegen.parser.AstNodeGenParser;
import de.fau.cs.osr.ptk.nodegen.parser.RatsDocGrammar;
import de.fau.cs.osr.utils.FmtInternalLogicError;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import xtc.parser.ParseError;
import xtc.parser.Result;
import xtc.parser.SemanticValue;

public class AstNodeGeneratorMojo
extends AbstractMojo {
    public static final String[] ratsExtensions = new String[]{"rats"};
    private MavenProject project;
    private MavenProjectProxy pproxy;
    private File baseDir;
    private File outputDir;
    private String[] ratsInputFiles;
    private File projectBaseDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArrayList<File> inputs;
        this.pproxy = new MavenProjectProxy(this.project);
        this.projectBaseDir = new File(this.pproxy.getBasedir().getAbsolutePath());
        if (!this.baseDir.isAbsolute()) {
            this.baseDir = new File(this.projectBaseDir, this.baseDir.getPath());
        }
        this.outputDir = this.getAbsolutePath(this.outputDir, this.projectBaseDir);
        this.pproxy.addCompileSourceRoot(this.outputDir.getPath());
        if (this.ratsInputFiles != null) {
            inputs = new ArrayList(this.ratsInputFiles.length);
            for (String input : this.ratsInputFiles) {
                inputs.add(new File(input));
            }
        } else {
            inputs = new ArrayList<File>();
            inputs.add(this.baseDir);
            this.getLog().debug((CharSequence)"Use grammar files found in base directory");
        }
        HashSet<File> sources = new HashSet<File>();
        for (File input : inputs) {
            this.resolveInput(this.getAbsolutePath(input, this.baseDir), sources);
        }
        this.getLog().info((CharSequence)("Parsing " + sources.size() + " grammar files"));
        for (File source : sources) {
            try {
                this.generate(source);
            }
            catch (Exception e) {
                String msg = "Exception occured when processing file: " + source.getAbsolutePath();
                this.getLog().error((CharSequence)msg);
                throw new MojoExecutionException(msg, e);
            }
        }
    }

    protected void generate(File file) throws MojoExecutionException, MojoFailureException, IOException {
        SemanticValue v;
        this.getLog().debug((CharSequence)("Generationg ast nodes from " + file.getName()));
        String source = FileUtils.readFileToString((File)file);
        AstNodeGenParser parser = new AstNodeGenParser(new StringReader(source), file.getAbsolutePath());
        parser.setLog(this.getLog());
        Result result = parser.pRatsDocGrammar(0);
        if (result.hasValue()) {
            v = (SemanticValue)result;
            if (!(v.value instanceof RatsDocGrammar)) {
                throw new FmtInternalLogicError();
            }
        } else {
            ParseError error = (ParseError)result;
            if (error.index == -1) {
                throw new ParseException("no information available.", new Object[0]);
            }
            throw new ParseException(error.msg, parser.location(error.index), new Object[0]);
        }
        this.transform((RatsDocGrammar)((Object)v.value));
    }

    private void transform(RatsDocGrammar value) throws IOException {
        RatsDocGrammarVisitor visitor = new RatsDocGrammarVisitor();
        visitor.go((Object)value);
        for (AstNodeSpec spec : visitor.getGeneratedNodes()) {
            File outDir = this.outputDir;
            String packageName = spec.getPackageName();
            if (packageName != null) {
                outDir = new File(outDir, packageName.replace('.', File.separatorChar));
            }
            outDir.mkdirs();
            File outFile = new File(outDir, spec.getNodeName() + ".java");
            FileUtils.writeStringToFile((File)outFile, (String)spec.getSource());
        }
    }

    protected void resolveInput(File input, Set<File> sources) {
        if (input.isDirectory()) {
            Iterator fileIterator = FileUtils.iterateFiles((File)input, (String[])ratsExtensions, (boolean)true);
            while (fileIterator.hasNext()) {
                sources.add((File)fileIterator.next());
            }
        } else {
            sources.add(input);
        }
    }

    protected File getAbsolutePath(File path, File baseDir) {
        if (path.isAbsolute()) {
            return path;
        }
        return new File(baseDir, path.getPath());
    }

    protected void setProjectProxy(MavenProjectProxy proxy) {
        this.pproxy = proxy;
    }

    protected void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }
}

