/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.nodegen;

import de.fau.cs.osr.ptk.common.Visitor;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import de.fau.cs.osr.ptk.common.ast.Text;
import de.fau.cs.osr.ptk.nodegen.AstNodeSpec;
import de.fau.cs.osr.ptk.nodegen.AstNodeSpecVisitor;
import de.fau.cs.osr.ptk.nodegen.AstNodeWriter;
import de.fau.cs.osr.ptk.nodegen.ParseException;
import de.fau.cs.osr.ptk.nodegen.parser.Item;
import de.fau.cs.osr.ptk.nodegen.parser.Itemize;
import de.fau.cs.osr.ptk.nodegen.parser.NameValue;
import de.fau.cs.osr.ptk.nodegen.parser.RatsDoc;
import de.fau.cs.osr.ptk.nodegen.parser.RatsDocGrammar;
import de.fau.cs.osr.ptk.nodegen.parser.Section;
import java.io.IOException;
import java.util.LinkedList;

public final class RatsDocGrammarVisitor
extends Visitor {
    private StringBuilder javadoc;
    private AstNodeSpecVisitor nodeSpecVisitor;
    private RatsDocGrammar ratsGrammar;
    private final LinkedList<AstNodeSpec> generatedNodes = new LinkedList();

    public LinkedList<AstNodeSpec> getGeneratedNodes() {
        return this.generatedNodes;
    }

    protected boolean before(AstNode node) {
        this.javadoc = new StringBuilder();
        return super.before(node);
    }

    protected Object after(AstNode node, Object result) {
        this.finishAstNodeSpec();
        return super.after(node, result);
    }

    public void visit(RatsDocGrammar n) {
        this.ratsGrammar = n;
        this.iterate((AstNode)n);
    }

    public void visit(RatsDoc n) {
        this.iterate((AstNode)n);
    }

    public void visit(NodeList n) {
        this.iterate((AstNode)n);
    }

    public void visit(Text t) {
        this.javadoc.append("<p>");
        this.javadoc.append("");
        this.javadoc.append(t.getContent().replace("\n\n", "\n<p>"));
        this.javadoc.append("</p>\n");
    }

    public void visit(NameValue n) {
        this.javadoc.append("<dl><dt>");
        this.javadoc.append(n.getName());
        this.javadoc.append(":</dt><dd>");
        this.javadoc.append(n.getValue());
        this.javadoc.append("</dd></dl>\n");
    }

    public void visit(Itemize n) {
        this.javadoc.append("<ul>\n");
        this.iterate((AstNode)n);
        this.javadoc.append("</ul>\n");
    }

    public void visit(Item n) {
        this.javadoc.append("<li>");
        this.iterate((AstNode)n);
        this.javadoc.append("</li>\n");
    }

    public void visit(Section n) throws IOException {
        if (n.getTitle().equals("AST node")) {
            if (n.getLevel() != 2) {
                throw new ParseException("Section `AST node' only allowed as second level section.", (AstNode)n, new Object[0]);
            }
            if (this.nodeSpecVisitor != null) {
                throw new ParseException("Only one `AST node' section allowed per Level 1 section.", (AstNode)n, new Object[0]);
            }
            this.nodeSpecVisitor = new AstNodeSpecVisitor(new AstNodeSpec(this.ratsGrammar.getModuleName()));
            this.nodeSpecVisitor.go(n.getBody());
        } else {
            if (n.getLevel() == 1) {
                this.finishAstNodeSpec();
                this.javadoc = new StringBuilder();
            }
            this.javadoc.append("<h");
            this.javadoc.append(n.getLevel());
            this.javadoc.append(">");
            this.javadoc.append(n.getTitle());
            this.javadoc.append("</h");
            this.javadoc.append(n.getLevel());
            this.javadoc.append(">\n");
            this.iterate((AstNode)n);
        }
    }

    private void finishAstNodeSpec() {
        if (this.nodeSpecVisitor != null) {
            AstNodeSpec spec = this.nodeSpecVisitor.getAstNodeSpec();
            spec.setClassJavadoc(this.javadoc.toString());
            try {
                AstNodeWriter.generate(spec);
                this.generatedNodes.add(spec);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.nodeSpecVisitor = null;
        }
    }
}

