/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.nodegen;

import de.fau.cs.osr.ptk.nodegen.AstNodeSpec;
import de.fau.cs.osr.ptk.nodegen.parser.NameValue;
import de.fau.cs.osr.utils.FmtFileNotFoundException;
import de.fau.cs.osr.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class AstNodeWriter {
    private static String tmplReflChildren = null;
    private static String tmplReflProperties = null;
    private static String tmplChild = null;
    private static String tmplConstructor = null;
    private static String tmplNodeType = null;
    private static String tmplProperty = null;
    private static String tmplClass = null;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final AstNodeSpec spec;
    private HashMap<String, String> parameterTypeMap;
    private Set<String> reservedWords = new HashSet<String>(Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"));

    public static void generate(AstNodeSpec spec) throws IOException {
        new AstNodeWriter(spec).generateClass();
    }

    public AstNodeWriter(AstNodeSpec spec) {
        this.spec = spec;
    }

    private void generateClass() throws IOException {
        String extraBody;
        if (tmplClass == null) {
            tmplClass = this.loadTemplate("skeleton-astnode");
        }
        String lastGenerated = dateFormat.format(new Date());
        String packageName = null;
        int i = this.spec.getModuleName().lastIndexOf(46);
        if (i > 0) {
            packageName = this.spec.getModuleName().substring(0, i);
        }
        String packageDecl = "";
        if (packageName != null) {
            packageDecl = "package " + packageName + ";";
        }
        String javadoc = this.formatJavadoc(this.spec.getClassJavadoc());
        String extraHeader = this.spec.getExtraHeader();
        if (extraHeader == null) {
            extraHeader = "";
        }
        extraBody = (extraBody = this.spec.getExtraBody()) == null ? "" : StringUtils.indent2((String)extraBody, (String)"\t");
        String source = tmplClass;
        source = source.replace("${version}", "AstNodeGenerator");
        source = source.replace("${lastGenerated}", lastGenerated);
        source = source.replace("${package}", packageDecl);
        source = source.replace("${imports}", this.generateImports());
        source = source.replace("${extraHeader}", extraHeader);
        source = source.replace("${javadoc}", javadoc);
        source = source.replace("${name}", this.spec.getNodeName());
        source = source.replace("${extends}", this.spec.getClassExtends());
        source = source.replace("${implements}", this.generateImplements());
        source = source.replace("${constructors}", this.generateConstructors());
        source = source.replace("${nodeType}", this.generateNodeType());
        source = source.replace("${properties}", this.generateProperties());
        source = source.replace("${propertiesReflection}", this.generatePropertiesReflection());
        source = source.replace("${children}", this.generateChildren());
        source = source.replace("${childrenReflection}", this.generateChildrenReflection());
        source = source.replace("${extraBody}", extraBody);
        this.spec.setPackageName(packageName);
        this.spec.setSource(source);
    }

    private String generateImports() {
        boolean i2;
        StringBuilder imports = new StringBuilder();
        imports.append("import de.fau.cs.osr.ptk.common.ast.*;\n");
        boolean i1 = this.spec.getChildren() != null && !this.spec.getChildren().isEmpty();
        boolean bl = i2 = this.spec.getProperties() != null && !this.spec.getProperties().isEmpty();
        if (i2) {
            // empty if block
        }
        if (i1 || i2) {
            // empty if block
        }
        for (String type : this.spec.getImports()) {
            imports.append("import ");
            imports.append(type.trim());
            imports.append(";\n");
        }
        return imports.toString();
    }

    private CharSequence generateImplements() {
        if (this.spec.getClassImplements().isEmpty()) {
            return "";
        }
        StringBuilder implements_ = new StringBuilder("implements ");
        int i = 0;
        for (String implement : this.spec.getClassImplements()) {
            if (i > 0) {
                implements_.append(", ");
            }
            implements_.append(implement);
        }
        return implements_.toString();
    }

    private String generateConstructors() throws IOException {
        StringBuilder constructors = new StringBuilder();
        if (tmplConstructor == null) {
            tmplConstructor = this.loadTemplate("skeleton-astnode-constructor");
        }
        this.buildTypeMap();
        constructors.append(this.generateConstructor(null));
        for (String parameterList : this.spec.getConstructors()) {
            constructors.append(this.generateConstructor(parameterList));
        }
        return constructors.toString();
    }

    private String generateNodeType() throws IOException {
        if (this.spec.getNodeType() != null) {
            if (tmplNodeType == null) {
                tmplNodeType = this.loadTemplate("skeleton-astnode-nodetype");
            }
            return tmplNodeType.replace("${nodeType}", this.spec.getNodeType());
        }
        return "";
    }

    private String generateConstructor(String parameterList) {
        String[] parameterNames;
        String name = this.spec.getNodeName();
        String parameters = "";
        if (parameterList != null) {
            parameterNames = parameterList.split("\\s*,\\s*");
            if (parameterNames.length > 1 || parameterNames.length == 1 && parameterNames[0] != null && !parameterNames[0].isEmpty()) {
                parameters = this.generateCtorParameters(parameterNames);
            }
        } else {
            parameterNames = new String[]{};
        }
        String setters = this.generateSetterInvocations(parameterNames);
        String superInvocation = this.generateSuperInvocation(parameterNames);
        String body = superInvocation + setters;
        String source = tmplConstructor;
        source = source.replace("${name}", name);
        source = source.replace("${parameters}", parameters);
        source = source.replace("${body}", body);
        return source;
    }

    private String generateCtorParameters(String[] parameterNames) {
        StringBuilder parameters = new StringBuilder();
        boolean first = true;
        for (String parameter : parameterNames) {
            if (!first) {
                parameters.append(", ");
            }
            String safeParameterName = parameter;
            if (this.reservedWords.contains(parameter)) {
                safeParameterName = parameter + "_";
            }
            parameters.append(this.parameterTypeMap.get(parameter));
            parameters.append(' ');
            parameters.append(safeParameterName);
            first = false;
        }
        return parameters.toString();
    }

    private String generateSetterInvocations(String[] parameterNames) {
        StringBuilder propertySetters = new StringBuilder();
        for (String parameter : parameterNames) {
            for (NameValue property : this.spec.getProperties()) {
                if (!parameter.equals(property.getName())) continue;
                String safeParameterName = parameter;
                if (this.reservedWords.contains(parameter)) {
                    safeParameterName = parameter + "_";
                }
                propertySetters.append("\t\tset");
                propertySetters.append(StringUtils.startWithUppercase((String)parameter));
                propertySetters.append('(');
                propertySetters.append(safeParameterName);
                propertySetters.append(");\n");
            }
        }
        return propertySetters.toString();
    }

    private String generateSuperInvocation(String[] parameterNames) {
        StringBuilder superInvocation = new StringBuilder();
        ArrayList<String> superParameters = new ArrayList<String>(this.spec.getChildren().size());
        if (this.spec.getClassExtends().equals("ContentNode") || this.spec.getClassExtends().equals("StringContentNode")) {
            if (Arrays.binarySearch(parameterNames, "content") >= 0) {
                superParameters.add("content");
            }
        } else {
            for (int i = 0; i < this.spec.getChildren().size(); ++i) {
                superParameters.add(null);
            }
            block1: for (String parameter : parameterNames) {
                for (int i = 0; i < this.spec.getChildren().size(); ++i) {
                    if (!this.spec.getChildren().get(i).getName().equals(parameter)) continue;
                    superParameters.set(i, parameter);
                    continue block1;
                }
            }
        }
        superInvocation.append("\t\tsuper(");
        int i = 0;
        for (String parameter : superParameters) {
            if (i != 0) {
                superInvocation.append(", ");
            }
            if (parameter == null) {
                String type = this.spec.getChildren().get(i).getValue();
                if (type.equals("AstNode")) {
                    superInvocation.append("(AstNode) null");
                } else {
                    superInvocation.append("new ");
                    superInvocation.append(type);
                    superInvocation.append("()");
                }
            } else {
                String safeParameterName = parameter;
                if (this.reservedWords.contains(parameter)) {
                    safeParameterName = parameter + "_";
                }
                superInvocation.append(safeParameterName);
            }
            ++i;
        }
        superInvocation.append(");\n");
        return superInvocation.toString();
    }

    private String generateProperties() throws IOException {
        StringBuilder properties = new StringBuilder();
        for (NameValue property : this.spec.getProperties()) {
            String name = property.getName();
            String type = property.getValue();
            String safeName = name;
            if (this.reservedWords.contains(name)) {
                safeName = name + "_";
            }
            if (tmplProperty == null) {
                tmplProperty = this.loadTemplate("skeleton-astnode-property");
            }
            String source = tmplProperty;
            source = source.replace("${name}", name);
            source = source.replace("${safeName}", safeName);
            source = source.replace("${name:underscore}", StringUtils.camelcaseToUppercase((String)name));
            source = source.replace("${name:firstUc}", StringUtils.startWithUppercase((String)name));
            source = source.replace("${type}", type);
            properties.append(source);
        }
        return properties.toString();
    }

    private String generatePropertiesReflection() throws IOException {
        StringBuilder combined = new StringBuilder();
        if (this.spec.getProperties() != null && !this.spec.getProperties().isEmpty()) {
            if (tmplReflProperties == null) {
                tmplReflProperties = this.loadTemplate("skeleton-astnode-reflection-properties");
            }
            StringBuilder getNameCases = new StringBuilder();
            StringBuilder getValueCases = new StringBuilder();
            StringBuilder setValueCases = new StringBuilder();
            int i = 0;
            for (NameValue property : this.spec.getProperties()) {
                String name = property.getName();
                String type = property.getValue();
                String ucName = StringUtils.startWithUppercase((String)name);
                getNameCases.append("\t\t\t\t\tcase ");
                getNameCases.append(i);
                getNameCases.append(":\n\t\t\t\t\t\treturn \"");
                getNameCases.append(name);
                getNameCases.append("\";\n");
                getValueCases.append("\t\t\t\t\tcase ");
                getValueCases.append(i);
                getValueCases.append(":\n\t\t\t\t\t\treturn ${className}.this.get");
                getValueCases.append(ucName);
                getValueCases.append("();\n");
                setValueCases.append("\t\t\t\t\tcase ");
                setValueCases.append(i);
                setValueCases.append(":\n\t\t\t\t\t\treturn ${className}.this.set");
                setValueCases.append(ucName);
                setValueCases.append("((");
                setValueCases.append(this.toObjectType(type));
                setValueCases.append(") value);\n");
                ++i;
            }
            String source = tmplReflProperties;
            source = source.replace("${getNameCases}", getNameCases.toString());
            source = source.replace("${getValueCases}", getValueCases.toString());
            source = source.replace("${setValueCases}", setValueCases.toString());
            source = source.replace("${propertyCount}", String.valueOf(this.spec.getProperties().size()));
            combined.append(source);
        }
        String result = combined.toString();
        result = result.replace("${className}", this.spec.getNodeName());
        return result;
    }

    private String generateChildren() throws IOException {
        StringBuilder children = new StringBuilder();
        if (tmplChild == null) {
            tmplChild = this.loadTemplate("skeleton-astnode-child");
        }
        int i = 0;
        for (NameValue child : this.spec.getChildren()) {
            String name = child.getName();
            String type = child.getValue();
            String index = Integer.toString(i);
            String safeName = name;
            if (this.reservedWords.contains(name)) {
                safeName = name + "_";
            }
            String source = tmplChild;
            source = source.replace("${name}", name);
            source = source.replace("${safeName}", safeName);
            source = source.replace("${name:firstUc}", StringUtils.startWithUppercase((String)name));
            source = source.replace("${type}", type);
            source = source.replace("${index}", index);
            children.append(source);
            ++i;
        }
        return children.toString();
    }

    private String generateChildrenReflection() throws IOException {
        StringBuilder combined = new StringBuilder();
        if (this.spec.getChildren() != null && !this.spec.getChildren().isEmpty()) {
            if (tmplReflChildren == null) {
                tmplReflChildren = this.loadTemplate("skeleton-astnode-reflection-children");
            }
            StringBuilder childNames = new StringBuilder();
            int i = 0;
            for (NameValue child : this.spec.getChildren()) {
                if (i++ > 0) {
                    childNames.append(", ");
                }
                childNames.append('\"');
                childNames.append(child.getName());
                childNames.append('\"');
            }
            String source = tmplReflChildren;
            source = source.replace("${childNames}", childNames.toString());
            combined.append(source);
        }
        return combined.toString();
    }

    private String formatJavadoc(String classJavadoc) {
        if (classJavadoc.isEmpty()) {
            return "";
        }
        StringBuilder javadoc = new StringBuilder();
        for (String line : classJavadoc.split("\\s*\n\\s*")) {
            javadoc.append(" * ");
            javadoc.append(line);
            javadoc.append("\n");
        }
        return javadoc.toString();
    }

    private void buildTypeMap() {
        if (this.parameterTypeMap == null) {
            this.parameterTypeMap = new HashMap();
            if (this.spec.getClassExtends().equals("ContentNode")) {
                this.parameterTypeMap.put("content", "NodeList");
            }
            if (this.spec.getClassExtends().equals("StringContentNode")) {
                this.parameterTypeMap.put("content", "String");
            }
            for (NameValue property : this.spec.getProperties()) {
                this.parameterTypeMap.put(property.getName(), property.getValue());
            }
            for (NameValue child : this.spec.getChildren()) {
                this.parameterTypeMap.put(child.getName(), child.getValue());
            }
        }
    }

    private String loadTemplate(String name) throws IOException {
        String resource = name + ".tmpl";
        InputStream in = this.getClass().getResourceAsStream(resource);
        if (in == null) {
            throw new FmtFileNotFoundException("Resource not found: `%s'.", new Object[]{resource});
        }
        return IOUtils.toString((InputStream)in);
    }

    private Object toObjectType(String type) {
        if ("byte".equals(type)) {
            return "Byte";
        }
        if ("short".equals(type)) {
            return "Short";
        }
        if ("int".equals(type)) {
            return "Integer";
        }
        if ("long".equals(type)) {
            return "Long";
        }
        if ("float".equals(type)) {
            return "Float";
        }
        if ("double".equals(type)) {
            return "Double";
        }
        if ("boolean".equals(type)) {
            return "Boolean";
        }
        if ("char".equals(type)) {
            return "Character";
        }
        return type;
    }
}

