/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.test;

import de.fau.cs.osr.utils.FmtFileNotFoundException;
import de.fau.cs.osr.utils.FmtIllegalArgumentException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class FileContent {
    private File file;
    private String content;

    public FileContent(File file) throws IOException {
        this.loadFile(file, "UTF-8");
    }

    public FileContent(File file, String encoding) throws IOException {
        this.loadFile(file, encoding);
    }

    protected void loadFile(File file, String encoding) throws IOException {
        if (encoding == null) {
            throw new FmtIllegalArgumentException("Argument `encoding' must not be null", new Object[0]);
        }
        if (file == null) {
            throw new FmtIllegalArgumentException("Argument `file' must not be null", new Object[0]);
        }
        if (!file.exists()) {
            throw new FmtFileNotFoundException("File not found: `%s'", new Object[]{file.getAbsolutePath()});
        }
        this.file = file;
        this.content = FileUtils.readFileToString((File)file, (String)encoding);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }
}

