/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.ast;

import java.io.Serializable;

public class Location
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String file;
    private final int line;
    private final int column;

    public Location() {
        this.file = "";
        this.line = -1;
        this.column = -1;
    }

    public Location(String file, int line, int column) {
        this.file = file;
        this.line = line;
        this.column = column;
    }

    public Location(Location location) {
        this.file = location.file;
        this.line = location.line;
        this.column = location.column;
    }

    public Location(xtc.tree.Location location) {
        this.file = location.file;
        this.line = location.line;
        this.column = location.column;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.column;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + this.line;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        if (this.column != other.column) {
            return false;
        }
        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
            return false;
        }
        return this.line == other.line;
    }

    public String toString() {
        if (this.getFile() == null) {
            return this.getLine() + ":" + this.getColumn();
        }
        return this.getFile() + ":" + this.getLine() + ":" + this.getColumn();
    }

    public static Location valueOf(String s) {
        int column;
        int line;
        String file = null;
        int i = s.indexOf(58);
        if (i == -1) {
            return null;
        }
        int j = s.indexOf(58, i + 1);
        if (j == -1) {
            line = Integer.parseInt(s.substring(0, i));
            column = Integer.parseInt(s.substring(i + 1));
        } else {
            file = s.substring(0, i);
            line = Integer.parseInt(s.substring(i + 1, j));
            column = Integer.parseInt(s.substring(j + 1));
        }
        return new Location(file, line, column);
    }

    public boolean isValid() {
        return this.line != -1;
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public xtc.tree.Location toXtcLocation() {
        return new xtc.tree.Location(this.file, this.line, this.column);
    }
}

