/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common;

import de.fau.cs.osr.ptk.common.VisitNotFoundException;
import de.fau.cs.osr.ptk.common.VisitingException;
import de.fau.cs.osr.ptk.common.VisitorException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;

public abstract class VisitorBase<T> {
    private static final int LOWER_CAPACITY = 256;
    private static final int UPPER_CAPACITY = 384;
    private static final float LOAD_FACTOR = 0.6f;
    private static final ConcurrentHashMap<Target, Target> cache = new ConcurrentHashMap(256, 0.6f);

    protected abstract Object dispatch(T var1);

    protected boolean before(T node) {
        return true;
    }

    protected Object after(T node, Object result) {
        return result;
    }

    protected Object visitNotFound(T node) {
        throw new VisitNotFoundException(this, node);
    }

    public final Object go(T node) {
        if (!this.before(node)) {
            return null;
        }
        Object result = this.dispatch(node);
        return this.after(node, result);
    }

    protected final Object resolveAndVisit(T node) {
        Class<?> vClass = this.getClass();
        Class<?> nClass = node.getClass();
        Target key = new Target(vClass, nClass);
        Target cached = cache.get(key);
        try {
            if (cached == null) {
                cached = this.findVisit(key);
            }
            if (cached.getMethod() == null) {
                return this.visitNotFound(node);
            }
            return cached.invoke(this, node);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof VisitingException) {
                throw (VisitingException)cause;
            }
            throw new VisitingException(node, cause);
        }
        catch (VisitingException e) {
            throw e;
        }
        catch (VisitNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VisitorException(node, (Throwable)e);
        }
    }

    private final Target findVisit(Target key) throws SecurityException {
        Method method = null;
        Class<?> vClass = key.getVClass();
        Class<?> nClass = key.getNClass();
        while (true) {
            try {
                method = vClass.getMethod("visit", nClass);
            }
            catch (NoSuchMethodException e) {
                if ((method = this.tryInterfaces(nClass.getInterfaces(), vClass)) == null && (nClass = nClass.getSuperclass()) != null) continue;
            }
            break;
        }
        Target target = new Target(key, method);
        Target cached = cache.putIfAbsent(target, target);
        if (cached != null) {
            return cached;
        }
        target.touch();
        if (cache.size() > 384) {
            this.sweepCache();
        }
        return target;
    }

    private Method tryInterfaces(Class<?>[] interfaces, Class<?> vClass) {
        Method method = null;
        for (Class<?> nClass : interfaces) {
            try {
                method = vClass.getMethod("visit", nClass);
                break;
            }
            catch (NoSuchMethodException e) {
                method = this.tryInterfaces(nClass.getInterfaces(), nClass);
                if (method != null) break;
            }
        }
        return method;
    }

    private final synchronized void sweepCache() {
        if (cache.size() <= 384) {
            return;
        }
        Object[] keys = new Target[cache.size()];
        Enumeration<Target> keysEnum = cache.keys();
        int i = 0;
        while (i < keys.length && keysEnum.hasMoreElements()) {
            keys[i++] = keysEnum.nextElement();
        }
        int length = i;
        Arrays.sort(keys, 0, length);
        int to = length - 256;
        for (int j = 0; j < to; ++j) {
            cache.remove(keys[j]);
        }
    }

    protected static final class Target
    implements Comparable<Target> {
        private static long useCounter = 0L;
        private long lastUse = -1L;
        private final Class<?> vClass;
        private final Class<?> nClass;
        private final Method method;

        public Target(Class<?> vClass, Class<?> nClass) {
            this.vClass = vClass;
            this.nClass = nClass;
            this.method = null;
        }

        public Target(Target key, Method method) {
            this.vClass = key.vClass;
            this.nClass = key.nClass;
            this.method = method;
        }

        public Class<?> getVClass() {
            return this.vClass;
        }

        public Class<?> getNClass() {
            return this.nClass;
        }

        public Method getMethod() {
            return this.method;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.nClass.hashCode();
            result = 31 * result + this.vClass.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            Target other = (Target)obj;
            if (this.nClass != other.nClass) {
                return false;
            }
            return this.vClass == other.vClass;
        }

        public void touch() {
            this.lastUse = ++useCounter;
        }

        public Object invoke(VisitorBase<?> visitor, Object node) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            this.touch();
            return this.method.invoke(visitor, node);
        }

        @Override
        public int compareTo(Target o) {
            return this.lastUse < o.lastUse ? -1 : 1;
        }

        public String toString() {
            return String.format("Target [%d - %s; %s:%s]", this.lastUse, this.method != null ? "O" : "X", this.vClass.getSimpleName(), this.nClass.getSimpleName());
        }
    }
}

