/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common;

import de.fau.cs.osr.ptk.common.AstVisitor;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.AstNodePropertyIterator;
import de.fau.cs.osr.ptk.common.ast.ContentNode;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import de.fau.cs.osr.ptk.common.ast.StringContentNode;
import de.fau.cs.osr.utils.StringUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AstPrinter
extends AstVisitor {
    protected PrintWriter out;
    private String indentStr = new String();
    private boolean legacyIndentation;
    private final HashMap<Memoize, Memoize> cache = new HashMap();

    public AstPrinter(Writer writer) {
        this.out = new PrintWriter(writer);
        this.legacyIndentation = false;
    }

    @Override
    protected Object after(AstNode node, Object result) {
        this.out.close();
        return super.after(node, result);
    }

    public void setLegacyIndentation(boolean legacyIndentation) {
        this.legacyIndentation = legacyIndentation;
    }

    public boolean isLegacyIndentation() {
        return this.legacyIndentation;
    }

    public static String print(AstNode node) {
        StringWriter writer = new StringWriter();
        new AstPrinter(writer).go(node);
        return writer.toString();
    }

    public static Writer print(Writer writer, AstNode node) {
        new AstPrinter(writer).go(node);
        return writer;
    }

    public void visit(AstNode n) {
        if (!this.replay(n)) {
            Memoize m = this.memoizeStart(n);
            if (n.isEmpty() && !n.hasAttributes() && !n.hasProperties()) {
                this.indent();
                this.out.println(n.getClass().getSimpleName() + "()");
            } else {
                this.indent();
                this.out.println(n.getClass().getSimpleName() + "(");
                this.incIndent();
                this.printNodeContent(n);
                this.decIndent();
                this.indent();
                this.out.println(")");
            }
            this.memoizeStop(m);
        }
    }

    public void visit(NodeList n) {
        if (!this.replay(n)) {
            Memoize m = this.memoizeStart(n);
            if (n.hasAttributes() || n.hasProperties()) {
                this.visit((AstNode)n);
            } else if (n.isEmpty()) {
                this.indent();
                this.out.println("[ ]");
            } else {
                this.incIndent();
                String singleLine = this.printNodeContentToString(n);
                this.decIndent();
                if (singleLine != null) {
                    this.indent();
                    this.out.println("[ " + singleLine + " ]");
                } else {
                    this.indent();
                    this.out.println("[");
                    this.incIndent();
                    this.printNodeContent(n);
                    this.decIndent();
                    this.indent();
                    this.out.println("]");
                }
            }
            this.memoizeStop(m);
        }
    }

    public void visit(ContentNode n) {
        if (!this.replay(n)) {
            Memoize m = this.memoizeStart(n);
            if (n.hasAttributes() || n.hasProperties()) {
                this.visit((AstNode)n);
            } else if (n.getContent().isEmpty()) {
                this.indent();
                this.out.println(n.getClass().getSimpleName() + "([ ])");
            } else {
                this.incIndent();
                String singleLine = this.printNodeContentToString(n.getContent());
                this.decIndent();
                if (singleLine != null) {
                    this.indent();
                    this.out.println(n.getClass().getSimpleName() + "([ " + singleLine + " ])");
                } else {
                    this.indent();
                    this.out.println(n.getClass().getSimpleName() + "([");
                    this.incIndent();
                    this.printNodeContent(n.getContent());
                    this.decIndent();
                    this.indent();
                    this.out.println("])");
                }
            }
            this.memoizeStop(m);
        }
    }

    public void visit(StringContentNode n) {
        if (!this.replay(n)) {
            Memoize m = this.memoizeStart(n);
            if (n.hasAttributes()) {
                this.visit((AstNode)n);
            } else {
                this.indent();
                this.out.println(n.getClass().getSimpleName() + "(" + this.mkStr(n.getContent()) + ")");
            }
            this.memoizeStop(m);
        }
    }

    protected boolean replay(AstNode n) {
        Memoize m = this.cache.get(new Memoize(this.indentStr.length(), n));
        if (m == null) {
            return false;
        }
        this.play(m);
        return true;
    }

    protected Memoize memoizeStart(AstNode n) {
        StringWriter w = new StringWriter();
        Memoize m = new Memoize(this.indentStr.length(), n, this.out, w);
        this.out = new PrintWriter(w);
        return m;
    }

    protected void memoizeStop(Memoize m) {
        this.out = m.getOldOut();
        this.cache.put(m, m);
        this.play(m);
    }

    private void play(Memoize m) {
        this.out.write(m.getText());
    }

    protected void printNodeContent(AstNode n) {
        Map<String, Object> attrs = n.getAttributes();
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.putAll(attrs);
        AstNodePropertyIterator i = n.propertyIterator();
        while (i.next()) {
            props.put(i.getName(), i.getValue());
        }
        if (!props.isEmpty()) {
            this.indent();
            this.out.println("Properties:");
        }
        ArrayList keys = new ArrayList(props.keySet());
        Collections.sort(keys);
        this.incIndent();
        for (String name : keys) {
            Object value = props.get(name);
            if (attrs.containsKey(name)) {
                this.indent();
                if (!this.legacyIndentation) {
                    this.out.print("    ");
                }
                this.out.print(name + " = ");
            } else {
                this.indent();
                this.out.print("{N} " + name + " = ");
            }
            if (value instanceof String) {
                this.out.println(this.mkStr((String)value));
                continue;
            }
            if (value instanceof AstNode) {
                this.out.println();
                this.incIndent();
                this.dispatch((AstNode)value);
                this.decIndent();
                continue;
            }
            if (value instanceof Collection) {
                Collection c = (Collection)value;
                if (c.isEmpty()) {
                    this.out.println("[]");
                    continue;
                }
                this.out.println();
                this.indent();
                this.out.println('[');
                this.incIndent();
                Iterator k = c.iterator();
                int last = c.size() - 1;
                int j = 0;
                while (k.hasNext()) {
                    Object o = k.next();
                    this.indent();
                    String s = "null";
                    if (o != null) {
                        s = o.toString();
                    }
                    this.out.println(j != last ? s + ',' : s);
                    ++j;
                }
                this.decIndent();
                this.indent();
                this.out.println(']');
                continue;
            }
            this.out.println(value);
        }
        this.decIndent();
        if (!props.isEmpty() && !n.isEmpty()) {
            this.out.println();
        }
        for (AstNode c : n) {
            this.dispatch(c);
        }
    }

    protected String printNodeContentToString(AstNode n) {
        String singleLine = null;
        if (n.size() == 1) {
            PrintWriter oldOut = this.out;
            StringWriter w = new StringWriter();
            this.out = new PrintWriter(w);
            this.printNodeContent(n);
            this.out = oldOut;
            singleLine = w.toString().trim();
            if (singleLine.indexOf(10) != -1 || singleLine.indexOf(13) != -1) {
                singleLine = null;
            }
        }
        return singleLine;
    }

    protected void incIndent() {
        this.indentStr = this.indentStr + "  ";
    }

    protected void decIndent() {
        this.indentStr = this.indentStr.substring(0, this.indentStr.length() - 2);
    }

    protected void indent() {
        this.out.print(this.indentStr);
    }

    private String mkStr(String str) {
        if (str == null) {
            return "null";
        }
        return '\"' + StringUtils.escJava((String)str) + '\"';
    }

    protected static final class Memoize {
        private final AstNode node;
        private final int indent;
        private final PrintWriter oldOut;
        private final StringWriter writer;

        public Memoize(int indent, AstNode node) {
            this.indent = indent;
            this.node = node;
            this.oldOut = null;
            this.writer = null;
        }

        public Memoize(int indent, AstNode node, PrintWriter oldOut, StringWriter writer) {
            this.indent = indent;
            this.node = node;
            this.oldOut = oldOut;
            this.writer = writer;
        }

        public PrintWriter getOldOut() {
            return this.oldOut;
        }

        public String getText() {
            return this.writer.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.indent;
            result = 31 * result + System.identityHashCode(this.node);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Memoize other = (Memoize)obj;
            if (this.indent != other.indent) {
                return false;
            }
            return this.node == other.node;
        }
    }
}

