/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.DomWriter;
import de.fau.cs.osr.ptk.common.VisitingException;
import de.fau.cs.osr.ptk.common.Visitor;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.xml.ObjectFactory;
import de.fau.cs.osr.ptk.common.xml.WikiTechAstNode;
import de.fau.cs.osr.ptk.common.xml.WikiTechAstProperty;
import de.fau.cs.osr.ptk.common.xml.WikitechAst;
import java.io.OutputStream;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlWriter
extends Visitor {
    private ObjectFactory objectFactory;
    private OutputStream out;
    private DOMImplementation domImplementation;

    public XmlWriter(OutputStream out) {
        this.out = out;
    }

    @Override
    protected final boolean before(AstNode node) {
        try {
            this.domImplementation = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation();
        }
        catch (ParserConfigurationException e) {
            throw new VisitingException(e);
        }
        this.objectFactory = new ObjectFactory();
        return super.before(node);
    }

    @Override
    protected Object after(AstNode node, Object result) {
        try {
            WikitechAst ast = this.objectFactory.createWikitechAst();
            ast.setNode((WikiTechAstNode)result);
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"de.fau.cs.osr.ptk.common.xml.xjc");
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.marshal((Object)ast, this.out);
        }
        catch (JAXBException e) {
            throw new VisitingException("Failed marshalling the AST", (Throwable)e);
        }
        return super.after(node, result);
    }

    public WikiTechAstNode visit(AstNode n) {
        WikiTechAstNode node = this.objectFactory.createWikiTechAstNode();
        node.setType(n.getNodeTypeName());
        Set<String> propertyNames = n.getAttributes().keySet();
        if (!propertyNames.isEmpty()) {
            WikiTechAstNode.Properties properties = this.objectFactory.createWikiTechAstNodeProperties();
            for (String name : propertyNames) {
                this.dumpProperty(properties, name, n.getAttribute(name));
            }
            node.setProperties(properties);
        }
        if (!n.isEmpty()) {
            WikiTechAstNode.Children children = this.objectFactory.createWikiTechAstNodeChildren();
            children.getNode().addAll(this.map(n));
            node.setChildren(children);
        }
        return node;
    }

    protected void dumpProperty(WikiTechAstNode.Properties properties, String name, Object value) {
        WikiTechAstProperty property = this.objectFactory.createWikiTechAstProperty();
        property.setName(name);
        if (value != null) {
            Class<?> clazz = value.getClass();
            if (clazz == Byte.class) {
                property.setByte((Byte)value);
            } else if (clazz == Short.class) {
                property.setShort((Short)value);
            } else if (clazz == Integer.class) {
                property.setInt((Integer)value);
            } else if (clazz == Long.class) {
                property.setLong((Long)value);
            } else if (clazz == Float.class) {
                property.setFloat((Float)value);
            } else if (clazz == Double.class) {
                property.setDouble((Double)value);
            } else if (clazz == Character.class) {
                property.setChar(((Character)value).toString());
            } else if (clazz == String.class) {
                property.setString((String)value);
            } else if (clazz == Boolean.class) {
                property.setBoolean((Boolean)value);
            } else {
                property.setObject(this.createDomFromObject(value));
            }
        }
        properties.getProperty().add(property);
    }

    private Object createDomFromObject(Object value) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        Document document = this.domImplementation.createDocument(null, "object", null);
        Element root = document.getDocumentElement();
        xstream.marshal(value, (HierarchicalStreamWriter)new DomWriter(document));
        return root;
    }
}

