/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.test;

import de.fau.cs.osr.utils.FmtIllegalArgumentException;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParserTestResources {
    File baseDirectory;

    public ParserTestResources(File baseDirectory) {
        if (!baseDirectory.exists()) {
            throw new FmtIllegalArgumentException("Given base directory `%s' does not exist", new Object[]{baseDirectory});
        }
        if (!baseDirectory.isDirectory()) {
            throw new FmtIllegalArgumentException("Given base directory `%s' is not a directory", new Object[]{baseDirectory});
        }
        this.baseDirectory = baseDirectory;
    }

    public List<File> gather(String directory, String glob, final boolean recursive) {
        LinkedList<File> files = new LinkedList<File>();
        final Pattern p = Pattern.compile(glob);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                Matcher matcher = p.matcher(name);
                if (matcher.matches()) {
                    return true;
                }
                if (recursive) {
                    return new File(dir, name).isDirectory();
                }
                return false;
            }
        };
        File dir = new File(this.baseDirectory, directory);
        if (!dir.exists()) {
            throw new FmtIllegalArgumentException("Given directory `%s' does not exist", new Object[]{dir.getAbsolutePath()});
        }
        if (!dir.isDirectory()) {
            throw new FmtIllegalArgumentException("Given directory `%s' is not a directory", new Object[]{dir.getAbsolutePath()});
        }
        ParserTestResources.gatherRecursive(dir, filter, files);
        Collections.sort(files);
        return files;
    }

    public String stripBaseDirectory(String text) {
        return text.replace(this.baseDirectory.getAbsolutePath(), "");
    }

    private static void gatherRecursive(File directory, FilenameFilter filter, List<File> gathered) {
        String[] files = directory.list(filter);
        if (files != null) {
            for (String fileName : files) {
                File file = new File(directory, fileName);
                if (file.isDirectory()) {
                    ParserTestResources.gatherRecursive(file, filter, gathered);
                    continue;
                }
                gathered.add(file);
            }
        }
    }

    public static File rebase(File file, String base, String rebase) {
        File rebasedFile = new File(file.getAbsolutePath().replace(base, rebase));
        if (!rebasedFile.exists()) {
            throw new FmtIllegalArgumentException("Rebased file `%s' does not exist", new Object[]{rebasedFile.getAbsolutePath()});
        }
        return rebasedFile;
    }

    public static File rebase(File file, String base, String rebase, String ext) {
        return ParserTestResources.rebase(file, base, rebase, ext, false);
    }

    public static File rebase(File file, String base, String rebase, String ext, boolean noThrow) {
        String rebased = file.getAbsolutePath().replace(base, rebase);
        int i = rebased.lastIndexOf(46);
        rebased = i < 0 ? rebased + "." + ext : rebased.substring(0, i + 1) + ext;
        File rebasedFile = new File(rebased);
        if (!rebasedFile.exists() && !noThrow) {
            throw new FmtIllegalArgumentException("Rebased file `%s' does not exist", new Object[]{rebasedFile.getAbsolutePath()});
        }
        return rebasedFile;
    }
}

