/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.test;

import de.fau.cs.osr.ptk.common.AstPrinterInterface;
import de.fau.cs.osr.ptk.common.ParserInterface;
import de.fau.cs.osr.ptk.common.Visitor;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.test.FileContent;
import de.fau.cs.osr.ptk.common.test.ParserTestResources;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import xtc.parser.ParseException;

public class ParserTestCommon {
    private final ParserTestResources resources;
    private final Class<?> parser;
    private final Pattern noRefReplace;
    private final String noRefReplaceBy;
    private final boolean randomRefName;

    public ParserTestCommon(ParserTestResources resources, Class<?> parserClass) {
        this.resources = resources;
        this.parser = parserClass;
        this.noRefReplace = null;
        this.noRefReplaceBy = null;
        this.randomRefName = true;
    }

    public ParserTestCommon(ParserTestResources resources, Class<?> parserClass, String noRefReplace, String noRefReplaceBy, boolean randomRefName) {
        this.resources = resources;
        this.parser = parserClass;
        this.noRefReplace = Pattern.compile(noRefReplace);
        this.noRefReplaceBy = noRefReplaceBy;
        this.randomRefName = randomRefName;
    }

    public List<String> gatherParseAndPrint(String wikitextDir, Visitor[] visitors, AstPrinterInterface printer) throws IOException, ParseException {
        List<File> input = this.resources.gather(wikitextDir, ".*?\\.wikitext", true);
        ArrayList<String> result = new ArrayList<String>(input.size());
        for (File wikitextFile : input) {
            result.add(this.parseAndPrint(visitors, printer, wikitextFile));
        }
        return result;
    }

    public void gatherParseAndPrintTest(String wikitextDir, String asttextDir, Visitor[] visitors, AstPrinterInterface printer) throws IOException, ParseException {
        System.out.println();
        System.out.println("Parser & Print test:");
        System.out.println("  Input:      " + wikitextDir);
        System.out.println("  Reference:  " + asttextDir);
        System.out.println("  Printer:    " + printer.getClass().getSimpleName());
        System.out.println();
        List<File> input = this.resources.gather(wikitextDir, ".*?\\.wikitext", true);
        for (File wikitextFile : input) {
            File asttextFile = ParserTestResources.rebase(wikitextFile, wikitextDir, asttextDir, printer.getPrintoutType(), true);
            System.out.println("Testing: " + wikitextDir + wikitextFile.getName());
            this.parseAndPrintTest(visitors, printer, wikitextFile, asttextFile);
        }
        System.out.println();
    }

    public String parseAndPrint(Visitor[] visitors, AstPrinterInterface printer, File wikitextFile) throws IOException, ParseException {
        FileContent wikitext = new FileContent(wikitextFile);
        AstNode ast = this.parse(wikitext, visitors);
        return this.printToString(ast, printer);
    }

    public void parseAndPrintTest(Visitor[] visitors, AstPrinterInterface printer, File wikitextFile, File reftextFile) throws IOException, ParseException {
        FileContent wikitext = new FileContent(wikitextFile);
        AstNode ast = this.parse(wikitext, visitors);
        String result = this.printToString(ast, printer);
        if (!reftextFile.exists()) {
            File create;
            if (this.noRefReplace != null) {
                String dir = reftextFile.getParentFile().getAbsolutePath();
                if (!this.noRefReplace.matcher(dir).find()) {
                    Assert.fail((String)"Reference file did not exist! FAILED TO WRITE REFERENCE FILE!");
                }
                dir = this.noRefReplace.matcher(dir).replaceAll(this.noRefReplaceBy);
                create = new File(dir);
                System.out.println(create.getAbsolutePath());
            } else {
                create = new File("").getAbsoluteFile();
            }
            create = this.randomRefName ? File.createTempFile(reftextFile.getName() + "-", "", create) : new File(create, reftextFile.getName());
            FileUtils.writeStringToFile((File)create, (String)result);
            Assert.fail((String)("Reference file did not exist! Wrote initial reference file to: " + create.getAbsolutePath()));
        }
        FileContent reftext = new FileContent(reftextFile);
        String reference = reftext.getContent();
        this.testEquals(wikitext, reftext, result, reference);
    }

    private void testEquals(FileContent wikitext, FileContent reftext, String result, String reference) {
        Assert.assertEquals((Object)reference, (Object)result);
    }

    public String printToString(AstNode ast, AstPrinterInterface printer) throws IOException {
        StringWriter writer = new StringWriter();
        printer.print(ast, writer);
        String result = writer.toString();
        return this.resources.stripBaseDirectory(result);
    }

    public AstNode parse(FileContent wikitext, Visitor[] visitors) throws IOException, ParseException {
        ParserInterface parser = this.instantiateParser();
        if (visitors != null) {
            parser.addVisitors(Arrays.asList(visitors));
        }
        return parser.parseArticle(wikitext.getContent(), wikitext.getFile().getAbsolutePath());
    }

    private ParserInterface instantiateParser() {
        try {
            return (ParserInterface)this.parser.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

