/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.jxpath;

import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.jxpath.AstNodeFieldIterator;
import de.fau.cs.osr.ptk.common.jxpath.AstNodeFieldPointer;
import de.fau.cs.osr.ptk.common.jxpath.AstPropertyIterator;
import de.fau.cs.osr.ptk.common.jxpath.AstPropertyPointer;
import de.fau.cs.osr.utils.FmtInternalLogicError;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;

public class AstNodePointer
extends NodePointer {
    private static final long serialVersionUID = 1L;
    private AstNode node;

    public AstNodePointer(AstNode node) {
        super(null);
        this.node = node;
    }

    public AstNodePointer(NodePointer parent, AstNode node) {
        super(parent);
        this.node = node;
    }

    public NodeIterator attributeIterator(QName name) {
        if (this.node.hasAttributes()) {
            return null;
        }
        return new AstPropertyIterator(this, name);
    }

    public NodeIterator childIterator(NodeTest test, boolean reverse, NodePointer startWith) {
        if (this.isLeaf()) {
            return null;
        }
        return new AstNodeFieldIterator(this, test, reverse, startWith);
    }

    public boolean isLeaf() {
        return this.node.isEmpty();
    }

    public boolean isActual() {
        return true;
    }

    public boolean isCollection() {
        return false;
    }

    public int getLength() {
        return 1;
    }

    public QName getName() {
        return new QName(null, this.getName2());
    }

    public Object getBaseValue() {
        return this.node;
    }

    public Object getImmediateNode() {
        return this.node;
    }

    public void setValue(Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        if (pointer1.getBaseValue() == pointer2.getBaseValue()) {
            return 0;
        }
        boolean p1IsProp = pointer1 instanceof AstPropertyPointer;
        boolean p2IsProp = pointer2 instanceof AstPropertyPointer;
        if (p1IsProp && !p2IsProp) {
            return -1;
        }
        if (!p1IsProp && p2IsProp) {
            return 1;
        }
        if (p1IsProp && p2IsProp) {
            AstPropertyPointer p1 = (AstPropertyPointer)pointer1;
            AstPropertyPointer p2 = (AstPropertyPointer)pointer2;
            int cmp = p1.getName2().compareTo(p2.getName2());
            if (cmp == 0) {
                throw new FmtInternalLogicError();
            }
            return cmp;
        }
        AstNode node1 = (AstNode)pointer1.getBaseValue();
        AstNode node2 = (AstNode)pointer2.getBaseValue();
        for (AstNode child : this.node) {
            if (child == node1) {
                return -1;
            }
            if (child != node2) continue;
            return 1;
        }
        throw new FmtInternalLogicError();
    }

    public String asPath() {
        StringBuffer buffer = new StringBuffer();
        if (this.parent != null) {
            buffer.append(this.parent.asPath());
            if (this.parent instanceof AstNodePointer || this.parent instanceof AstNodeFieldPointer) {
                if (buffer.length() == 0 || buffer.charAt(buffer.length() - 1) != '/') {
                    buffer.append('/');
                }
                buffer.append(this.getName2());
                if (this.parent != null) {
                    buffer.append('[');
                    buffer.append(this.getRelativePosition());
                    buffer.append(']');
                }
            }
        } else {
            buffer.append('/');
        }
        return buffer.toString();
    }

    private int getRelativePosition() {
        if (this.parent != null) {
            if (this.parent instanceof AstNodePointer || this.parent instanceof AstNodeFieldPointer) {
                NodePointer p = this.parent;
                AstNode thisNode = (AstNode)this.getImmediateNode();
                int i = 1;
                for (AstNode n : (AstNode)p.getImmediateNode()) {
                    if (n == thisNode) {
                        return i;
                    }
                    ++i;
                }
                throw new FmtInternalLogicError();
            }
            return 1;
        }
        return 1;
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AstNodePointer other = (AstNodePointer)((Object)obj);
        return this.node == other.node;
    }

    public boolean testNode(NodeTest test) {
        if (test == null) {
            return true;
        }
        if (test instanceof NodeNameTest) {
            String s2;
            NodeNameTest nodeNameTest = (NodeNameTest)test;
            QName testName = nodeNameTest.getNodeName();
            if (testName.getPrefix() != null) {
                return false;
            }
            if (nodeNameTest.isWildcard()) {
                return true;
            }
            String s1 = this.getName2();
            return s1 == (s2 = testName.getName()) || s1.equals(s2);
        }
        if (test instanceof NodeTypeTest) {
            NodeTypeTest nodeTypeTest = (NodeTypeTest)test;
            switch (nodeTypeTest.getNodeType()) {
                case 1: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private String getName2() {
        return this.node.getClass().getSimpleName();
    }
}

