/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.ast;

import de.fau.cs.osr.ptk.common.ast.AstChildIterator;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.InnerNode;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import xtc.util.Pair;

public class NodeList
extends InnerNode {
    private static final long serialVersionUID = -3855416846550776026L;
    private LinkedList<AstNode> children = new LinkedList();

    public NodeList() {
    }

    public NodeList(AstNode child) {
        this.add(child);
    }

    public NodeList(AstNode car, Pair<? extends AstNode> cdr) {
        this.add(car);
        this.addAll(cdr);
    }

    public NodeList(AstNode a, AstNode b) {
        this.add(a);
        this.add(b);
    }

    public NodeList(AstNode a, AstNode b, AstNode c) {
        this.add(a);
        this.add(b);
        this.add(c);
    }

    public NodeList(AstNode a, AstNode b, AstNode c, AstNode d) {
        this.add(a);
        this.add(b);
        this.add(c);
        this.add(d);
    }

    public NodeList(Pair<? extends AstNode> list) {
        this.addAll(list);
    }

    public NodeList(Collection<? extends AstNode> list) {
        this.addAll(list);
    }

    @Override
    public int getNodeType() {
        return 2;
    }

    @Override
    public int size() {
        return this.children.size();
    }

    @Override
    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.children.contains(o);
    }

    @Override
    public Iterator<AstNode> iterator() {
        return this.children.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.children.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.children.toArray(a);
    }

    @Override
    public boolean add(AstNode e) {
        if (e == null) {
            return false;
        }
        if (e.getNodeType() == 2) {
            return this.children.addAll(((NodeList)e).children);
        }
        return this.children.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.children.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.children.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends AstNode> c) {
        boolean changed = false;
        for (AstNode astNode : c) {
            changed |= this.add(astNode);
        }
        return changed;
    }

    @Override
    public boolean addAll(int index, Collection<? extends AstNode> c) {
        LinkedList<AstNode> insert = new LinkedList<AstNode>();
        for (AstNode astNode : c) {
            if (astNode == null) continue;
            if (astNode.getNodeType() == 2) {
                insert.addAll(((NodeList)astNode).children);
                continue;
            }
            insert.add(astNode);
        }
        return this.children.addAll(index, insert);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.children.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.children.retainAll(c);
    }

    @Override
    public void clear() {
        this.children.clear();
    }

    @Override
    public AstNode get(int index) {
        return this.children.get(index);
    }

    @Override
    public AstNode set(int index, AstNode value) {
        if (value == null) {
            throw new NullPointerException("A NodeList must not contain a null element!");
        }
        if (value.getNodeType() == 2) {
            throw new IllegalArgumentException("Must not set a single element to a NodeList");
        }
        return this.children.set(index, value);
    }

    @Override
    public void add(int index, AstNode element) {
        if (element == null) {
            return;
        }
        if (element.getNodeType() == 2) {
            this.addAll(index, element);
        } else {
            this.children.add(index, element);
        }
    }

    @Override
    public AstNode remove(int index) {
        return this.children.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.children.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.children.lastIndexOf(o);
    }

    @Override
    public ListIterator<AstNode> listIterator() {
        return new ChildListIterator();
    }

    @Override
    public ListIterator<AstNode> listIterator(int index) {
        return new ChildListIterator(index);
    }

    @Override
    public List<AstNode> subList(int fromIndex, int toIndex) {
        return this.children.subList(fromIndex, toIndex);
    }

    @Override
    public boolean addAll(Pair<? extends AstNode> p) {
        boolean changed = false;
        while (!p.isEmpty()) {
            changed |= this.add((AstNode)p.head());
            p = p.tail();
        }
        return changed;
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public String[] getChildNames() {
        return EMPTY_CHILD_NAMES;
    }

    @Override
    public void toString(Appendable out) throws IOException {
        out.append('[');
        boolean first = true;
        for (AstNode node : this) {
            if (first) {
                first = false;
            } else {
                out.append(", ");
            }
            if (node == null) {
                out.append("null");
                continue;
            }
            node.toString(out);
        }
        out.append(']');
    }

    private final class ChildListIterator
    implements AstChildIterator {
        private ListIterator<AstNode> i;
        private AstNode current = null;
        private final int start;

        public ChildListIterator() {
            this.start = 0;
            this.reset();
        }

        public ChildListIterator(int index) {
            this.start = index;
            this.reset();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public AstNode next() {
            this.current = this.i.next();
            return this.current;
        }

        @Override
        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        @Override
        public AstNode previous() {
            this.current = this.i.previous();
            return this.current;
        }

        @Override
        public int nextIndex() {
            return this.i.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.i.previousIndex();
        }

        @Override
        public void remove() {
            this.i.remove();
            this.current = null;
        }

        @Override
        public void set(AstNode e) {
            if (e == null) {
                throw new NullPointerException("A NodeList must not contain a null element!");
            }
            if (e.getNodeType() == 2) {
                throw new IllegalArgumentException("Must not set a single element to a NodeList");
            }
            this.i.set(e);
            this.current = e;
        }

        @Override
        public void add(AstNode e) {
            if (e == null) {
                return;
            }
            if (e.getNodeType() == 2) {
                for (AstNode n : (NodeList)e) {
                    this.i.add(n);
                }
                this.current = null;
            } else {
                this.i.add(e);
                this.current = null;
            }
        }

        @Override
        public AstNode get() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            return this.current;
        }

        @Override
        public void reset() {
            this.i = NodeList.this.children.listIterator(this.start);
        }
    }
}

