/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.ast;

import java.io.Serializable;

public class Location
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String file;
    private final int line;
    private final int column;

    public Location() {
        this.file = "";
        this.line = -1;
        this.column = -1;
    }

    public Location(String file, int line, int column) {
        this.file = file;
        this.line = line;
        this.column = column;
    }

    public Location(Location location) {
        this.file = location.file;
        this.line = location.line;
        this.column = location.column;
    }

    public Location(xtc.tree.Location location) {
        this.file = location.file;
        this.line = location.line;
        this.column = location.column;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.column;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + this.line;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        if (this.column != other.column) {
            return false;
        }
        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
            return false;
        }
        return this.line == other.line;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.file);
        buf.append(':');
        buf.append(this.line);
        buf.append(':');
        buf.append(this.column);
        return buf.toString();
    }

    public boolean isValid() {
        return this.line != -1;
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public xtc.tree.Location toXtcLocation() {
        return new xtc.tree.Location(this.file, this.line, this.column);
    }
}

