/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.ast;

import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.Location;
import de.fau.cs.osr.utils.Utils;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;

public class AstNodeInputStream
extends DataInputStream {
    private final ArrayList<String> cache = new ArrayList(4096);
    private final ObjectInputStream objectInputStream;

    public AstNodeInputStream(InputStream is) throws IOException {
        super(is);
        this.objectInputStream = new ObjectInputStream(is);
    }

    public AstNode readNode() throws IOException, ClassNotFoundException {
        return this.checkObjId(256) ? this.readNodeObj() : null;
    }

    public Location readLocation() throws IOException {
        return this.checkObjId(257) ? this.readLocationObj() : null;
    }

    public String readString() throws IOException {
        int objId = this.readInt();
        if (objId == 0) {
            return null;
        }
        int id = objId & 0xFFFF;
        if (id == 16) {
            return this.readStringObj(objId);
        }
        throw new FormatException("Wrong object ID " + id + ", expected ID " + 16);
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        int objId = this.readInt();
        switch (objId & 0xFFFF) {
            case 0: {
                return null;
            }
            case 1: {
                return this.readObj();
            }
            case 16: {
                return this.readStringObj(objId);
            }
            case 32: {
                return new Byte(this.readByte());
            }
            case 33: {
                return new Short(this.readShort());
            }
            case 34: {
                return new Integer(this.readInt());
            }
            case 35: {
                return new Long(this.readLong());
            }
            case 36: {
                return new Float(this.readFloat());
            }
            case 37: {
                return new Double(this.readDouble());
            }
            case 256: {
                return this.readNodeObj();
            }
            case 257: {
                return this.readLocationObj();
            }
        }
        throw new FormatException("Unknown object ID");
    }

    private boolean checkObjId(int expectedObjId) throws IOException {
        int objId = this.readInt();
        if (objId == 0) {
            return false;
        }
        if ((objId &= 0xFFFF) == expectedObjId) {
            return true;
        }
        throw new FormatException("Wrong object ID " + objId + ", expected ID " + expectedObjId);
    }

    private Location readLocationObj() throws IOException {
        String file = this.readString();
        int line = this.readInt();
        int column = this.readInt();
        return new Location(file, line, column);
    }

    private AstNode readNodeObj() throws IOException, ClassNotFoundException {
        String className = this.readClassName();
        Class<?> clazz = Class.forName(className);
        AstNode node = (AstNode)Utils.getInstance(clazz);
        node.deserializeFrom(this);
        return node;
    }

    private Object readObj() throws IOException, ClassNotFoundException {
        Object o = this.objectInputStream.readObject();
        return o;
    }

    private String readStringObj(int objId) throws IOException {
        return this.readCached(objId);
    }

    private String readClassName() throws IOException {
        int objId = this.readInt();
        return this.readCached(objId);
    }

    private String readCached(int objId) throws IOException, FormatException {
        if ((objId & 0x10000) != 0) {
            int strId = this.readInt();
            if (strId < 0 || strId >= this.cache.size()) {
                throw new FormatException("String ID out of bounds: " + strId);
            }
            return this.cache.get(strId);
        }
        String str = this.readUTF();
        this.cache.add(str);
        return str;
    }

    public class FormatException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public FormatException() {
        }

        public FormatException(String message, Throwable cause) {
            super(message, cause);
        }

        public FormatException(String message) {
            super(message);
        }

        public FormatException(Throwable cause) {
            super(cause);
        }
    }
}

