/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.ast;

import de.fau.cs.osr.ptk.common.ast.AstChildIterator;
import de.fau.cs.osr.ptk.common.ast.AstNodeAttributeInterface;
import de.fau.cs.osr.ptk.common.ast.AstNodeInputStream;
import de.fau.cs.osr.ptk.common.ast.AstNodeOutputStream;
import de.fau.cs.osr.ptk.common.ast.AstNodePropertyInterface;
import de.fau.cs.osr.ptk.common.ast.AstNodePropertyIterator;
import de.fau.cs.osr.ptk.common.ast.Location;
import de.fau.cs.osr.ptk.common.ast.NoSuchPropertyException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import xtc.tree.Locatable;
import xtc.util.Pair;

public abstract class AstNode
implements List<AstNode>,
AstNodePropertyInterface,
AstNodeAttributeInterface,
Locatable,
Cloneable,
Serializable {
    private static final long serialVersionUID = 3333532331617925714L;
    public static final int NT_CUSTOM_BIT = 65536;
    public static final int NT_UNTYPED = -1;
    public static final int NT_NODE_LIST = 2;
    public static final int NT_CONTENT_NODE = 3;
    public static final int NT_STRING_CONTENT_NODE = 4;
    public static final int NT_PARSER_ENTITY = 5;
    public static final int NT_TUPLE_1 = 257;
    public static final int NT_TUPLE_2 = 258;
    public static final int NT_TUPLE_3 = 259;
    public static final int NT_TUPLE_4 = 260;
    public static final int NT_TUPLE_5 = 261;
    public static final int NT_TEXT = 4097;
    protected static final String[] EMPTY_CHILD_NAMES = new String[0];
    private HashMap<String, Object> attributes;
    private Location location;

    public AstNode() {
    }

    public AstNode(Location location) {
        this.setNativeLocation(location);
    }

    public AstNode(xtc.tree.Location location) {
        this.setLocation(location);
    }

    public int getNodeType() {
        return -1;
    }

    public boolean isNodeType(int testType) {
        return this.getNodeType() == testType;
    }

    public final String getNodeTypeName() {
        return this.getClass().getName();
    }

    public final String getNodeName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public final boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    @Override
    public final Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public final void setAttributes(Map<String, Object> attrs) {
        this.attributes = new HashMap<String, Object>(attrs);
    }

    @Override
    public final void clearAttributes() {
        this.attributes = null;
    }

    @Override
    public final boolean hasAttribute(String name) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.containsKey(name);
    }

    @Override
    public final Object getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    @Override
    public final Object setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        return this.attributes.put(name, value);
    }

    @Override
    public final Object removeAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        Object value = this.attributes.remove(name);
        if (this.attributes.isEmpty()) {
            this.attributes = null;
        }
        return value;
    }

    @Override
    public final int getIntAttribute(String name) {
        if (this.attributes == null) {
            return 0;
        }
        return (Integer)this.attributes.get(name);
    }

    @Override
    public final Integer setIntAttribute(String name, Integer value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        return (Integer)this.attributes.put(name, value);
    }

    @Override
    public final boolean getBooleanAttribute(String name) {
        if (this.attributes == null) {
            return false;
        }
        Object o = this.attributes.get(name);
        if (null == o) {
            return false;
        }
        return (Boolean)o;
    }

    @Override
    public final boolean setBooleanAttribute(String name, boolean value) {
        Boolean o;
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        if ((o = (Boolean)this.attributes.put(name, value)) == null) {
            return false;
        }
        return o;
    }

    @Override
    public final String getStringAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return (String)this.attributes.get(name);
    }

    @Override
    public final String setStringAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        return (String)this.attributes.put(name, value);
    }

    @Override
    public final boolean hasProperties() {
        return this.getPropertyCount() > 0;
    }

    @Override
    public int getPropertyCount() {
        return 0;
    }

    @Override
    public Object getProperty(String name) {
        AstNodePropertyIterator i = this.propertyIterator();
        while (i.next()) {
            if (!i.getName().equals(name)) continue;
            return i.getValue();
        }
        throw new NoSuchPropertyException();
    }

    @Override
    public Object setProperty(String name, Object value) {
        AstNodePropertyIterator i = this.propertyIterator();
        while (i.next()) {
            if (!i.getName().equals(name)) continue;
            return i.getValue();
        }
        throw new NoSuchPropertyException();
    }

    @Override
    public AstNodePropertyIterator propertyIterator() {
        return new AstNodePropertyIterator(){

            @Override
            protected String getName(int index) {
                throw new IndexOutOfBoundsException();
            }

            @Override
            protected Object getValue(int index) {
                throw new IndexOutOfBoundsException();
            }

            @Override
            protected Object setValue(int index, Object value) {
                throw new IndexOutOfBoundsException();
            }

            @Override
            protected int getPropertyCount() {
                return 0;
            }
        };
    }

    public final boolean hasLocation() {
        return this.location != null;
    }

    public final xtc.tree.Location getLocation() {
        return this.location.toXtcLocation();
    }

    public final void setLocation(xtc.tree.Location location) {
        this.setNativeLocation(new Location(location));
    }

    public final void setLocation(Locatable locatable) {
        if (locatable.hasLocation()) {
            this.setLocation(locatable.getLocation());
        }
    }

    public final Location getNativeLocation() {
        return this.location;
    }

    public final void setNativeLocation(Location location) {
        this.location = location;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<AstNode> iterator() {
        return new ChildIterator();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(AstNode e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends AstNode> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends AstNode> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equals((AstNode)obj);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + this.propertyHash();
        result = 31 * result + this.childrenHash();
        return result;
    }

    @Override
    public AstNode get(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AstNode set(int index, AstNode value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, AstNode element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AstNode remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<AstNode> listIterator() {
        return new ChildListIterator();
    }

    @Override
    public ListIterator<AstNode> listIterator(int index) {
        return new ChildListIterator(index);
    }

    @Override
    public List<AstNode> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Pair<? extends AstNode> p) {
        throw new UnsupportedOperationException();
    }

    public boolean isList() {
        return false;
    }

    public String[] getChildNames() {
        return EMPTY_CHILD_NAMES;
    }

    public void toString(Appendable out) throws IOException {
        out.append(this.getClass().getSimpleName());
        out.append('(');
        boolean first = true;
        for (AstNode node : this) {
            if (first) {
                first = false;
            } else {
                out.append(", ");
            }
            if (node == null) {
                out.append("null");
                continue;
            }
            node.toString(out);
        }
        out.append(')');
    }

    public String toString() {
        StringBuilder buf;
        block2: {
            buf = new StringBuilder();
            try {
                this.toString(buf);
            }
            catch (IOException x) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return buf.toString();
    }

    protected Object clone() throws CloneNotSupportedException {
        AstNode n = (AstNode)super.clone();
        n.location = new Location(n.location);
        n.attributes = new HashMap<String, Object>(n.attributes);
        return n;
    }

    public void serializeTo(AstNodeOutputStream os) throws IOException {
        this.defaultSerializeTo(os);
    }

    public void deserializeFrom(AstNodeInputStream is) throws IOException, ClassNotFoundException {
        this.defaultDeserializeFrom(is);
    }

    protected final void defaultSerializeTo(AstNodeOutputStream os) throws IOException {
        os.writeObject(this.location);
        this.serializeAttributes(os);
        this.serializeProperties(os);
        this.serializeChildren(os);
    }

    protected final void defaultDeserializeFrom(AstNodeInputStream is) throws IOException, ClassNotFoundException {
        this.location = (Location)is.readObject();
        this.deserializeAttributes(is);
        this.deserializeProperties(is);
        this.deserializeChildren(is);
    }

    protected final void serializeAttributes(AstNodeOutputStream os) throws IOException {
        if (this.attributes != null && !this.attributes.isEmpty()) {
            Map.Entry[] props = this.attributes.entrySet().toArray(new Map.Entry[0]);
            Arrays.sort(props, new Comparator<Map.Entry<String, Object>>(){

                @Override
                public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
                    return o1.getKey().compareTo(o2.getKey());
                }
            });
            os.writeInt(props.length);
            for (Map.Entry prop : props) {
                os.writeUTF((String)prop.getKey());
                os.writeObject(prop.getValue());
            }
        } else {
            os.writeInt(0);
        }
    }

    protected final void serializeProperties(AstNodeOutputStream os) throws IOException {
        AstNodePropertyIterator i = this.propertyIterator();
        while (i.next()) {
            os.writeObject(i.getValue());
        }
    }

    protected final void serializeChildren(AstNodeOutputStream os) throws IOException {
        os.writeInt(this.size());
        for (AstNode child : this) {
            os.writeNode(child);
        }
    }

    protected final void deserializeAttributes(AstNodeInputStream is) throws IOException, ClassNotFoundException {
        this.attributes = null;
        int propCount = is.readInt();
        for (int i = 0; i < propCount; ++i) {
            String key = is.readUTF();
            Object value = is.readObject();
            this.setAttribute(key, value);
        }
    }

    protected final void deserializeProperties(AstNodeInputStream is) throws IOException, ClassNotFoundException {
        AstNodePropertyIterator i = this.propertyIterator();
        while (i.next()) {
            i.setValue(is.readObject());
        }
    }

    protected final void deserializeChildren(AstNodeInputStream is) throws IOException, ClassNotFoundException {
        int size = is.readInt();
        if (this.isList()) {
            for (int i = 0; i < size; ++i) {
                this.add(is.readNode());
            }
        } else {
            for (int i = 0; i < size; ++i) {
                this.set(i, is.readNode());
            }
        }
    }

    public final int propertyHash() {
        int hash = 0;
        AstNodePropertyIterator i = this.propertyIterator();
        while (i.next()) {
            hash += i.getName().hashCode();
            hash += i.getValue() == null ? 0 : i.getValue().hashCode();
        }
        return hash;
    }

    public final int childrenHash() {
        int hash = 0;
        for (AstNode n : this) {
            hash += n == null ? 0 : n.hashCode();
        }
        return hash;
    }

    public final boolean equals(AstNode other) {
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        AstNodePropertyIterator p1 = this.propertyIterator();
        AstNodePropertyIterator p2 = other.propertyIterator();
        while (p1.next() & p2.next()) {
            Object v1 = p1.getValue();
            Object v2 = p2.getValue();
            if (!(v1 == null ? v2 != null : !v1.equals(v2))) continue;
            return false;
        }
        Iterator<AstNode> i1 = this.iterator();
        Iterator<AstNode> i2 = other.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            AstNode n1 = i1.next();
            AstNode n2 = i2.next();
            if (!(n1 == null ? n2 != null : !n1.equals(n2))) continue;
            return false;
        }
        return i1.hasNext() == i2.hasNext();
    }

    private final class ChildListIterator
    implements AstChildIterator {
        protected final int size;
        protected int cursor;
        protected int current;
        protected int start;

        public ChildListIterator() {
            this.size = AstNode.this.size();
            this.start = 0;
            this.cursor = 0;
            this.current = -1;
        }

        public ChildListIterator(int index) {
            this.size = AstNode.this.size();
            this.start = index;
            this.cursor = index;
            this.current = -1;
        }

        @Override
        public void reset() {
            this.cursor = this.start;
            this.current = -1;
        }

        @Override
        public void set(AstNode e) {
            if (this.current == -1) {
                throw new IllegalStateException();
            }
            AstNode.this.set(this.current, e);
        }

        @Override
        public AstNode get() {
            if (this.current == -1) {
                throw new IllegalStateException();
            }
            return AstNode.this.get(this.current);
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > this.start;
        }

        @Override
        public AstNode previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.current = --this.cursor;
            return AstNode.this.get(this.current);
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.size;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public AstNode next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.current = this.cursor++;
            return AstNode.this.get(this.current);
        }

        @Override
        public void add(AstNode e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class ChildIterator
    implements Iterator<AstNode> {
        protected final int size;
        protected int cursor;

        private ChildIterator() {
            this.size = AstNode.this.size();
            this.cursor = 0;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.size;
        }

        @Override
        public AstNode next() {
            if (this.hasNext()) {
                return AstNode.this.get(this.cursor++);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not implemented for this iterator");
        }
    }
}

