/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common;

import de.fau.cs.osr.ptk.common.VisitNotFoundException;
import de.fau.cs.osr.ptk.common.VisitingException;
import de.fau.cs.osr.ptk.common.VisitorException;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentHashMap;

public class Visitor {
    private static final int LOWER_CAPACITY = 256;
    private static final int UPPER_CAPACITY = 384;
    private static final float LOAD_FACTOR = 0.6f;
    private static final ConcurrentHashMap<Target, Target> cache = new ConcurrentHashMap(256, 0.6f);

    public final Object go(AstNode node) {
        if (!this.before(node)) {
            return null;
        }
        Object result = this.dispatch(node);
        return this.after(node, result);
    }

    protected final Object dispatch(AstNode node) {
        if (node == null) {
            return null;
        }
        return this.visit(node);
    }

    protected final void iterate(AstNode node) {
        if (node != null) {
            for (AstNode n : node) {
                this.dispatch(n);
            }
        }
    }

    protected final List<Object> map(AstNode node) {
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(node.size());
        for (AstNode n : node) {
            result.add(this.dispatch(n));
        }
        return result;
    }

    protected final void mapInPlace(AstNode node) {
        if (node == null) {
            return;
        }
        if (node.getNodeType() == 2) {
            this.mapInPlace((NodeList)node);
        } else {
            ListIterator<AstNode> i = node.listIterator();
            while (i.hasNext()) {
                AstNode current = i.next();
                AstNode result = (AstNode)this.dispatch(current);
                if (result == current) continue;
                i.set(result);
            }
        }
    }

    protected final void mapInPlace(NodeList list) {
        if (list == null) {
            return;
        }
        ListIterator<AstNode> i = list.listIterator();
        while (i.hasNext()) {
            AstNode current = i.next();
            AstNode result = (AstNode)this.dispatch(current);
            if (result == current) continue;
            if (result == null) {
                i.remove();
                continue;
            }
            if (result.getNodeType() == 2) {
                i.remove();
                i.add(result);
                continue;
            }
            i.set(result);
        }
    }

    protected boolean before(AstNode node) {
        return true;
    }

    protected Object after(AstNode node, Object result) {
        return result;
    }

    protected Object visitNotFound(AstNode node) {
        throw new VisitNotFoundException(this, node);
    }

    private final Object visit(AstNode node) {
        Class<?> vClass = this.getClass();
        Class<?> nClass = node.getClass();
        Target key = new Target(vClass, nClass);
        Target cached = cache.get(key);
        try {
            if (cached == null && !cache.contains(key)) {
                cached = this.findVisit(key);
            }
            if (cached.getMethod() == null) {
                return this.visitNotFound(node);
            }
            return cached.invoke(this, node);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof VisitingException) {
                throw (VisitingException)cause;
            }
            throw new VisitingException(node, cause);
        }
        catch (VisitingException e) {
            throw e;
        }
        catch (VisitNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VisitorException(node, (Throwable)e);
        }
    }

    private final Target findVisit(Target key) throws SecurityException {
        Method method = null;
        Class<? extends Visitor> vClass = key.getVClass();
        Class<? extends AstNode> nClass = key.getNClass();
        while (true) {
            try {
                method = vClass.getMethod("visit", nClass);
            }
            catch (NoSuchMethodException e) {
                if ((nClass = nClass.getSuperclass()) != null) continue;
            }
            break;
        }
        Target target = new Target(key, method);
        Target cached = cache.putIfAbsent(target, target);
        if (cached != null) {
            return cached;
        }
        target.touch();
        if (cache.size() > 384) {
            this.sweepCache();
        }
        return target;
    }

    private final synchronized void sweepCache() {
        if (cache.size() <= 384) {
            return;
        }
        Object[] keys = new Target[cache.size()];
        Enumeration<Target> keysEnum = cache.keys();
        int i = 0;
        while (i < keys.length && keysEnum.hasMoreElements()) {
            keys[i++] = keysEnum.nextElement();
        }
        int length = i;
        Arrays.sort(keys, 0, length);
        int to = length - 256;
        for (int j = 0; j < to; ++j) {
            cache.remove(keys[j]);
        }
    }

    private static final class Target
    implements Comparable<Target> {
        private static int useCounter = 0;
        private int lastUse = -1;
        private final Class<? extends Visitor> vClass;
        private final Class<? extends AstNode> nClass;
        private final Method method;

        public Target(Class<? extends Visitor> vClass, Class<? extends AstNode> nClass) {
            this.vClass = vClass;
            this.nClass = nClass;
            this.method = null;
        }

        public Target(Target key, Method method) {
            this.vClass = key.vClass;
            this.nClass = key.nClass;
            this.method = method;
        }

        public Class<? extends Visitor> getVClass() {
            return this.vClass;
        }

        public Class<? extends AstNode> getNClass() {
            return this.nClass;
        }

        public Method getMethod() {
            return this.method;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.nClass.hashCode();
            result = 31 * result + this.vClass.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            Target other = (Target)obj;
            if (this.nClass != other.nClass) {
                return false;
            }
            return this.vClass == other.vClass;
        }

        public void touch() {
            this.lastUse = ++useCounter;
        }

        public Object invoke(Visitor visitor, AstNode node) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            this.touch();
            return this.method.invoke((Object)visitor, node);
        }

        @Override
        public int compareTo(Target o) {
            return this.lastUse < o.lastUse ? -1 : 1;
        }

        public String toString() {
            return String.format("Target [%d - %s; %s:%s]", this.lastUse, this.method != null ? "O" : "X", this.vClass.getSimpleName(), this.nClass.getSimpleName());
        }
    }
}

