/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common;

import de.fau.cs.osr.ptk.common.Visitor;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.utils.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Stack;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class PrinterBase
extends Visitor {
    private PrintWriter out;
    private Stack<String> indent = new Stack();
    private boolean needIndent = true;

    protected PrinterBase(Writer writer) {
        this.out = new PrintWriter(writer);
        this.indent.push("");
    }

    @Override
    protected Object after(AstNode node, Object result) {
        this.out.close();
        return super.after(node, result);
    }

    protected void incIndent(String inc) {
        this.indent.push(this.indent.peek() + inc);
    }

    protected void decIndent() {
        this.indent.pop();
    }

    protected void print(String text) {
        if (text == null) {
            return;
        }
        if (this.needIndent) {
            this.out.append(this.indent.peek());
            this.needIndent = false;
        }
        this.out.append(text);
    }

    protected void print(int number) {
        this.print(String.valueOf(number));
    }

    protected void printNewline(boolean force) {
        if (!this.needIndent || force) {
            this.out.append("\n");
            this.needIndent = true;
        }
    }

    protected String indentText(String text) {
        return StringUtils.indent2((String)text, (String)this.indent.peek());
    }

    protected static String load(File file) throws IOException {
        return FileUtils.readFileToString((File)file);
    }

    protected String loadFromResource(String resourceName) throws IOException {
        InputStream in = this.getClass().getResourceAsStream(resourceName);
        if (in == null) {
            throw new FileNotFoundException("Resource not found: `" + resourceName + "'.");
        }
        return IOUtils.toString((InputStream)in);
    }

    protected static String camelCaseToUppercase(String name) {
        return StringUtils.camelcaseToUppercase((String)name);
    }

    protected static String startWithUppercase(String name) {
        return StringUtils.startWithUppercase((String)name);
    }

    protected static String escHtml(String text) {
        return StringUtils.escHtml((String)text);
    }

    protected static String escJavaHtml(String text) {
        return StringUtils.escHtml((String)StringUtils.escJava((String)text));
    }

    protected static String strrep(char ch, int rep) {
        return StringUtils.strrep((char)ch, (int)rep);
    }

    protected static String strrep(String str, int rep) {
        return StringUtils.strrep((String)str, (int)rep);
    }
}

