/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.reporting;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Clock;
import com.yammer.metrics.core.CounterMetric;
import com.yammer.metrics.core.GaugeMetric;
import com.yammer.metrics.core.HistogramMetric;
import com.yammer.metrics.core.Metered;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsProcessor;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Percentiled;
import com.yammer.metrics.core.Summarized;
import com.yammer.metrics.core.TimerMetric;
import com.yammer.metrics.core.VirtualMachineMetrics;
import com.yammer.metrics.reporting.AbstractPollingReporter;
import com.yammer.metrics.reporting.SocketProvider;
import com.yammer.metrics.util.MetricPredicate;
import com.yammer.metrics.util.Utils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphiteReporter
extends AbstractPollingReporter
implements MetricsProcessor<Long> {
    private static final Logger LOG = LoggerFactory.getLogger(GraphiteReporter.class);
    private final String prefix;
    private final MetricPredicate predicate;
    private final Locale locale = Locale.US;
    private Writer writer;
    private Clock clock;
    private final SocketProvider socketProvider;
    public boolean printVMMetrics = true;

    public static void enable(long period, TimeUnit unit, String host, int port) {
        GraphiteReporter.enable(Metrics.defaultRegistry(), period, unit, host, port);
    }

    public static void enable(MetricsRegistry metricsRegistry, long period, TimeUnit unit, String host, int port) {
        GraphiteReporter.enable(metricsRegistry, period, unit, host, port, null);
    }

    public static void enable(long period, TimeUnit unit, String host, int port, String prefix) {
        GraphiteReporter.enable(Metrics.defaultRegistry(), period, unit, host, port, prefix);
    }

    public static void enable(MetricsRegistry metricsRegistry, long period, TimeUnit unit, String host, int port, String prefix) {
        GraphiteReporter.enable(metricsRegistry, period, unit, host, port, prefix, MetricPredicate.ALL);
    }

    public static void enable(MetricsRegistry metricsRegistry, long period, TimeUnit unit, String host, int port, String prefix, MetricPredicate predicate) {
        try {
            GraphiteReporter reporter = new GraphiteReporter(metricsRegistry, prefix, predicate, new DefaultSocketProvider(host, port), Clock.DEFAULT);
            reporter.start(period, unit);
        }
        catch (Exception e) {
            LOG.error("Error creating/starting Graphite reporter:", (Throwable)e);
        }
    }

    public GraphiteReporter(String host, int port, String prefix) throws IOException {
        this(Metrics.defaultRegistry(), host, port, prefix);
    }

    public GraphiteReporter(MetricsRegistry metricsRegistry, String host, int port, String prefix) throws IOException {
        this(metricsRegistry, prefix, MetricPredicate.ALL, new DefaultSocketProvider(host, port), Clock.DEFAULT);
    }

    public GraphiteReporter(MetricsRegistry metricsRegistry, String prefix, MetricPredicate predicate, SocketProvider socketProvider, Clock clock) throws IOException {
        super(metricsRegistry, "graphite-reporter");
        this.socketProvider = socketProvider;
        this.clock = clock;
        this.prefix = prefix != null ? prefix + "." : "";
        this.predicate = predicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Socket socket = null;
        try {
            socket = this.socketProvider.get();
            this.writer = new OutputStreamWriter(socket.getOutputStream());
            long epoch = this.clock.time() / 1000L;
            if (this.printVMMetrics) {
                this.printVmMetrics(epoch);
            }
            this.printRegularMetrics(epoch);
            this.writer.flush();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error writing to Graphite", (Throwable)e);
            } else {
                LOG.warn("Error writing to Graphite: {}", (Object)e.getMessage());
            }
            if (this.writer != null) {
                try {
                    this.writer.flush();
                }
                catch (IOException e1) {
                    LOG.error("Error while flushing writer:", (Throwable)e1);
                }
            }
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    LOG.error("Error while closing socket:", (Throwable)e);
                }
            }
            this.writer = null;
        }
    }

    private void printRegularMetrics(Long epoch) {
        for (Map.Entry entry : Utils.sortAndFilterMetrics((Map)this.metricsRegistry.allMetrics(), (MetricPredicate)this.predicate).entrySet()) {
            for (Map.Entry subEntry : ((Map)entry.getValue()).entrySet()) {
                Metric metric = (Metric)subEntry.getValue();
                if (metric == null) continue;
                try {
                    metric.processWith((MetricsProcessor)this, (MetricName)subEntry.getKey(), (Object)epoch);
                }
                catch (Exception ignored) {
                    LOG.error("Error printing regular metrics:", (Throwable)ignored);
                }
            }
        }
    }

    private void sendToGraphite(String data) {
        try {
            this.writer.write(data);
        }
        catch (IOException e) {
            LOG.error("Error sending to Graphite:", (Throwable)e);
        }
    }

    private String sanitizeName(MetricName name) {
        StringBuilder sb = new StringBuilder().append(name.getGroup()).append('.').append(name.getType()).append('.');
        if (name.hasScope()) {
            sb.append(name.getScope()).append('.');
        }
        return sb.append(name.getName()).toString().replace(' ', '-');
    }

    public void processGauge(MetricName name, GaugeMetric<?> gauge, Long epoch) throws IOException {
        this.sendToGraphite(String.format(this.locale, "%s%s.%s %s %d\n", this.prefix, this.sanitizeName(name), "value", gauge.value(), epoch));
    }

    public void processCounter(MetricName name, CounterMetric counter, Long epoch) throws IOException {
        this.sendToGraphite(String.format(this.locale, "%s%s.%s %d %d\n", this.prefix, this.sanitizeName(name), "count", counter.count(), epoch));
    }

    public void processMeter(MetricName name, Metered meter, Long epoch) throws IOException {
        String sanitizedName = this.sanitizeName(name);
        StringBuilder lines = new StringBuilder();
        lines.append(String.format(this.locale, "%s%s.%s %d %d\n", this.prefix, sanitizedName, "count", meter.count(), epoch));
        lines.append(String.format(this.locale, "%s%s.%s %2.2f %d\n", this.prefix, sanitizedName, "meanRate", meter.meanRate(), epoch));
        lines.append(String.format(this.locale, "%s%s.%s %2.2f %d\n", this.prefix, sanitizedName, "1MinuteRate", meter.oneMinuteRate(), epoch));
        lines.append(String.format(this.locale, "%s%s.%s %2.2f %d\n", this.prefix, sanitizedName, "5MinuteRate", meter.fiveMinuteRate(), epoch));
        lines.append(String.format(this.locale, "%s%s.%s %2.2f %d\n", this.prefix, sanitizedName, "15MinuteRate", meter.fifteenMinuteRate(), epoch));
        this.sendToGraphite(lines.toString());
    }

    public void processHistogram(MetricName name, HistogramMetric histogram, Long epoch) throws IOException {
        String sanitizedName = this.sanitizeName(name);
        StringBuilder lines = new StringBuilder();
        this.printSummarized((Summarized)histogram, sanitizedName, epoch, lines);
        this.printPercentiled((Percentiled)histogram, sanitizedName, epoch, lines);
        this.sendToGraphite(lines.toString());
    }

    public void processTimer(MetricName name, TimerMetric timer, Long epoch) throws IOException {
        this.processMeter(name, (Metered)timer, epoch);
        String sanitizedName = this.sanitizeName(name);
        Double[] percentiles = timer.percentiles(new Double[]{0.5, 0.75, 0.95, 0.98, 0.99, 0.999});
        StringBuilder lines = new StringBuilder();
        this.printSummarized((Summarized)timer, sanitizedName, epoch, lines);
        this.printPercentiled((Percentiled)timer, sanitizedName, epoch, lines);
        this.sendToGraphite(lines.toString());
    }

    private void printSummarized(Summarized metric, String sanitizedName, Long epoch, Appendable lines) throws IOException {
        lines.append(String.format(this.locale, "%s%s.%s %2.2f %d\n", this.prefix, sanitizedName, "min", metric.min(), epoch));
        lines.append(String.format(this.locale, "%s%s.%s %2.2f %d\n", this.prefix, sanitizedName, "max", metric.max(), epoch));
        lines.append(String.format(this.locale, "%s%s.%s %2.2f %d\n", this.prefix, sanitizedName, "mean", metric.mean(), epoch));
        lines.append(String.format(this.locale, "%s%s.%s %2.2f %d\n", this.prefix, sanitizedName, "stddev", metric.stdDev(), epoch));
    }

    private void printPercentiled(Percentiled metric, String sanitizedName, Long epoch, Appendable lines) throws IOException {
        Double[] percentiles = metric.percentiles(new Double[]{0.5, 0.75, 0.95, 0.98, 0.99, 0.999});
        lines.append(String.format(this.locale, "%s%s.%s %2.2f %d\n", this.prefix, sanitizedName, "median", percentiles[0], epoch));
        lines.append(String.format(this.locale, "%s%s.%s %2.2f %d\n", this.prefix, sanitizedName, "75percentile", percentiles[1], epoch));
        lines.append(String.format(this.locale, "%s%s.%s %2.2f %d\n", this.prefix, sanitizedName, "95percentile", percentiles[2], epoch));
        lines.append(String.format(this.locale, "%s%s.%s %2.2f %d\n", this.prefix, sanitizedName, "98percentile", percentiles[3], epoch));
        lines.append(String.format(this.locale, "%s%s.%s %2.2f %d\n", this.prefix, sanitizedName, "99percentile", percentiles[4], epoch));
        lines.append(String.format(this.locale, "%s%s.%s %2.2f %d\n", this.prefix, sanitizedName, "999percentile", percentiles[5], epoch));
    }

    private void printDoubleField(String name, double value, long epoch) {
        this.sendToGraphite(String.format(this.locale, "%s%s %2.2f %d\n", this.prefix, name, value, epoch));
    }

    private void printLongField(String name, long value, long epoch) {
        this.sendToGraphite(String.format(this.locale, "%s%s %d %d\n", this.prefix, name, value, epoch));
    }

    private void printVmMetrics(long epoch) {
        this.printDoubleField("jvm.memory.heap_usage", VirtualMachineMetrics.heapUsage(), epoch);
        this.printDoubleField("jvm.memory.non_heap_usage", VirtualMachineMetrics.nonHeapUsage(), epoch);
        for (Map.Entry pool : VirtualMachineMetrics.memoryPoolUsage().entrySet()) {
            this.printDoubleField("jvm.memory.memory_pool_usages." + (String)pool.getKey(), (Double)pool.getValue(), epoch);
        }
        this.printDoubleField("jvm.daemon_thread_count", VirtualMachineMetrics.daemonThreadCount(), epoch);
        this.printDoubleField("jvm.thread_count", VirtualMachineMetrics.threadCount(), epoch);
        this.printDoubleField("jvm.uptime", VirtualMachineMetrics.uptime(), epoch);
        this.printDoubleField("jvm.fd_usage", VirtualMachineMetrics.fileDescriptorUsage(), epoch);
        for (Map.Entry entry : VirtualMachineMetrics.threadStatePercentages().entrySet()) {
            this.printDoubleField("jvm.thread-states." + ((Thread.State)((Object)entry.getKey())).toString().toLowerCase(), (Double)entry.getValue(), epoch);
        }
        for (Map.Entry entry : VirtualMachineMetrics.garbageCollectors().entrySet()) {
            this.printLongField("jvm.gc." + (String)entry.getKey() + ".time", ((VirtualMachineMetrics.GarbageCollector)entry.getValue()).getTime(TimeUnit.MILLISECONDS), epoch);
            this.printLongField("jvm.gc." + (String)entry.getKey() + ".runs", ((VirtualMachineMetrics.GarbageCollector)entry.getValue()).getRuns(), epoch);
        }
    }

    private static class DefaultSocketProvider
    implements SocketProvider {
        private final String host;
        private final int port;

        public DefaultSocketProvider(String host, int port) {
            this.host = host;
            this.port = port;
        }

        @Override
        public Socket get() throws Exception {
            return new Socket(this.host, this.port);
        }
    }
}

