/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.reporting;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.CounterMetric;
import com.yammer.metrics.core.GaugeMetric;
import com.yammer.metrics.core.HistogramMetric;
import com.yammer.metrics.core.Metered;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsProcessor;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.TimerMetric;
import com.yammer.metrics.core.VirtualMachineMetrics;
import com.yammer.metrics.reporting.AbstractPollingReporter;
import com.yammer.metrics.reporting.GangliaMessageBuilder;
import com.yammer.metrics.util.MetricPredicate;
import com.yammer.metrics.util.Utils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GangliaReporter
extends AbstractPollingReporter
implements MetricsProcessor<String> {
    private static final Logger LOG = LoggerFactory.getLogger(GangliaReporter.class);
    private static final int GANGLIA_TMAX = 60;
    private static final int GANGLIA_DMAX = 0;
    private static final String GANGLIA_INT_TYPE = "int32";
    private static final String GANGLIA_DOUBLE_TYPE = "double";
    private final MetricPredicate predicate;
    private final Locale locale = Locale.US;
    private String hostLabel;
    private String groupPrefix = "";
    private boolean compressPackageNames;
    private final GangliaMessageBuilder gangliaMessageBuilder;
    public boolean printVMMetrics = true;

    public static void enable(long period, TimeUnit unit, String gangliaHost, int port) {
        GangliaReporter.enable(Metrics.defaultRegistry(), period, unit, gangliaHost, port, "");
    }

    public static void enable(long period, TimeUnit unit, String gangliaHost, int port, String groupPrefix) {
        GangliaReporter.enable(Metrics.defaultRegistry(), period, unit, gangliaHost, port, groupPrefix);
    }

    public static void enable(long period, TimeUnit unit, String gangliaHost, int port, boolean compressPackageNames) {
        GangliaReporter.enable(Metrics.defaultRegistry(), period, unit, gangliaHost, port, "", MetricPredicate.ALL, compressPackageNames);
    }

    public static void enable(MetricsRegistry metricsRegistry, long period, TimeUnit unit, String gangliaHost, int port, String groupPrefix) {
        GangliaReporter.enable(metricsRegistry, period, unit, gangliaHost, port, groupPrefix, MetricPredicate.ALL);
    }

    public static void enable(MetricsRegistry metricsRegistry, long period, TimeUnit unit, String gangliaHost, int port, String groupPrefix, MetricPredicate predicate) {
        GangliaReporter.enable(metricsRegistry, period, unit, gangliaHost, port, groupPrefix, predicate, false);
    }

    public static void enable(MetricsRegistry metricsRegistry, long period, TimeUnit unit, String gangliaHost, int port, String groupPrefix, MetricPredicate predicate, boolean compressPackageNames) {
        try {
            GangliaReporter reporter = new GangliaReporter(metricsRegistry, gangliaHost, port, groupPrefix, predicate, compressPackageNames);
            reporter.start(period, unit);
        }
        catch (Exception e) {
            LOG.error("Error creating/starting ganglia reporter:", (Throwable)e);
        }
    }

    public GangliaReporter(String gangliaHost, int port) throws IOException {
        this(Metrics.defaultRegistry(), gangliaHost, port, "");
    }

    public GangliaReporter(String gangliaHost, int port, boolean compressPackageNames) throws IOException {
        this(Metrics.defaultRegistry(), gangliaHost, port, "", MetricPredicate.ALL, compressPackageNames);
    }

    public GangliaReporter(MetricsRegistry metricsRegistry, String gangliaHost, int port, String groupPrefix) throws IOException {
        this(metricsRegistry, gangliaHost, port, groupPrefix, MetricPredicate.ALL);
    }

    public GangliaReporter(MetricsRegistry metricsRegistry, String gangliaHost, int port, String groupPrefix, MetricPredicate predicate) throws IOException {
        this(metricsRegistry, gangliaHost, port, groupPrefix, predicate, false);
    }

    public GangliaReporter(MetricsRegistry metricsRegistry, String gangliaHost, int port, String groupPrefix, MetricPredicate predicate, boolean compressPackageNames) throws IOException {
        this(metricsRegistry, groupPrefix, predicate, compressPackageNames, new GangliaMessageBuilder(gangliaHost, port));
    }

    public GangliaReporter(MetricsRegistry metricsRegistry, String groupPrefix, MetricPredicate predicate, boolean compressPackageNames, GangliaMessageBuilder gangliaMessageBuilder) throws IOException {
        super(metricsRegistry, "ganglia-reporter");
        this.gangliaMessageBuilder = gangliaMessageBuilder;
        this.groupPrefix = groupPrefix + "_";
        this.hostLabel = this.getHostLabel();
        this.predicate = predicate;
        this.compressPackageNames = compressPackageNames;
    }

    public void run() {
        if (this.printVMMetrics) {
            this.printVmMetrics();
        }
        this.printRegularMetrics();
    }

    private void printRegularMetrics() {
        for (Map.Entry entry : Utils.sortAndFilterMetrics((Map)this.metricsRegistry.allMetrics(), (MetricPredicate)this.predicate).entrySet()) {
            for (Map.Entry subEntry : ((Map)entry.getValue()).entrySet()) {
                Metric metric = (Metric)subEntry.getValue();
                if (metric == null) continue;
                try {
                    metric.processWith((MetricsProcessor)this, (MetricName)subEntry.getKey(), null);
                }
                catch (Exception ignored) {
                    LOG.error("Error printing regular metrics:", (Throwable)ignored);
                }
            }
        }
    }

    private void sendToGanglia(String metricName, String metricType, String metricValue, String groupName, String units) {
        try {
            this.sendMetricData(metricType, metricName, metricValue, this.groupPrefix + groupName, units);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Emitting metric " + metricName + ", type " + metricType + ", value " + metricValue + " for gangliaHost: " + this.gangliaMessageBuilder.getHostName() + ":" + this.gangliaMessageBuilder.getPort());
            }
        }
        catch (IOException e) {
            LOG.error("Error sending to ganglia:", (Throwable)e);
        }
    }

    private void sendToGanglia(String metricName, String metricType, String metricValue, String groupName) {
        this.sendToGanglia(metricName, metricType, metricValue, groupName, "");
    }

    private void sendMetricData(String metricType, String metricName, String metricValue, String groupName, String units) throws IOException {
        this.gangliaMessageBuilder.newMessage().addInt(128).addString(this.hostLabel).addString(metricName).addInt(0).addString(metricType).addString(metricName).addString(units).addInt(3).addInt(60).addInt(0).addInt(1).addString("GROUP").addString(groupName).send();
        this.gangliaMessageBuilder.newMessage().addInt(133).addString(this.hostLabel).addString(metricName).addInt(0).addString("%s").addString(metricValue).send();
    }

    public void processGauge(MetricName name, GaugeMetric<?> gauge, String x) throws IOException {
        this.sendToGanglia(this.sanitizeName(name), GANGLIA_INT_TYPE, String.format(this.locale, "%s", gauge.value()), "gauge");
    }

    public void processCounter(MetricName name, CounterMetric counter, String x) throws IOException {
        this.sendToGanglia(this.sanitizeName(name), GANGLIA_INT_TYPE, String.format(this.locale, "%d", counter.count()), "counter");
    }

    public void processMeter(MetricName name, Metered meter, String x) throws IOException {
        String sanitizedName = this.sanitizeName(name);
        String units = meter.rateUnit().name();
        this.printLongField(sanitizedName + ".count", meter.count(), "metered", units);
        this.printDoubleField(sanitizedName + ".meanRate", meter.meanRate(), "metered", units);
        this.printDoubleField(sanitizedName + ".1MinuteRate", meter.oneMinuteRate(), "metered", units);
        this.printDoubleField(sanitizedName + ".5MinuteRate", meter.fiveMinuteRate(), "metered", units);
        this.printDoubleField(sanitizedName + ".15MinuteRate", meter.fifteenMinuteRate(), "metered", units);
    }

    public void processHistogram(MetricName name, HistogramMetric histogram, String x) throws IOException {
        String sanitizedName = this.sanitizeName(name);
        Double[] percentiles = histogram.percentiles(new Double[]{0.5, 0.75, 0.95, 0.98, 0.99, 0.999});
        this.printDoubleField(sanitizedName + ".min", histogram.min(), "histo");
        this.printDoubleField(sanitizedName + ".max", histogram.max(), "histo");
        this.printDoubleField(sanitizedName + ".mean", histogram.mean(), "histo");
        this.printDoubleField(sanitizedName + ".stddev", histogram.stdDev(), "histo");
        this.printDoubleField(sanitizedName + ".median", percentiles[0], "histo");
        this.printDoubleField(sanitizedName + ".75percentile", percentiles[1], "histo");
        this.printDoubleField(sanitizedName + ".95percentile", percentiles[2], "histo");
        this.printDoubleField(sanitizedName + ".98percentile", percentiles[3], "histo");
        this.printDoubleField(sanitizedName + ".99percentile", percentiles[4], "histo");
        this.printDoubleField(sanitizedName + ".999percentile", percentiles[5], "histo");
    }

    public void processTimer(MetricName name, TimerMetric timer, String x) throws IOException {
        this.processMeter(name, (Metered)timer, x);
        String sanitizedName = this.sanitizeName(name);
        Double[] percentiles = timer.percentiles(new Double[]{0.5, 0.75, 0.95, 0.98, 0.99, 0.999});
        String durationUnit = timer.durationUnit().name();
        this.printDoubleField(sanitizedName + ".min", timer.min(), "timer", durationUnit);
        this.printDoubleField(sanitizedName + ".max", timer.max(), "timer", durationUnit);
        this.printDoubleField(sanitizedName + ".mean", timer.mean(), "timer", durationUnit);
        this.printDoubleField(sanitizedName + ".stddev", timer.stdDev(), "timer", durationUnit);
        this.printDoubleField(sanitizedName + ".median", percentiles[0], "timer", durationUnit);
        this.printDoubleField(sanitizedName + ".75percentile", percentiles[1], "timer", durationUnit);
        this.printDoubleField(sanitizedName + ".95percentile", percentiles[2], "timer", durationUnit);
        this.printDoubleField(sanitizedName + ".98percentile", percentiles[3], "timer", durationUnit);
        this.printDoubleField(sanitizedName + ".99percentile", percentiles[4], "timer", durationUnit);
        this.printDoubleField(sanitizedName + ".999percentile", percentiles[5], "timer", durationUnit);
    }

    private void printDoubleField(String name, double value, String groupName, String units) {
        this.sendToGanglia(name, GANGLIA_DOUBLE_TYPE, String.format(this.locale, "%2.2f", value), groupName, units);
    }

    private void printDoubleField(String name, double value, String groupName) {
        this.printDoubleField(name, value, groupName, "");
    }

    private void printLongField(String name, long value, String groupName) {
        this.printLongField(name, value, groupName, "");
    }

    private void printLongField(String name, long value, String groupName, String units) {
        this.sendToGanglia(name, GANGLIA_INT_TYPE, String.format(this.locale, "%d", value), groupName, units);
    }

    private void printVmMetrics() {
        this.printDoubleField("jvm.memory.heap_usage", VirtualMachineMetrics.heapUsage(), "jvm");
        this.printDoubleField("jvm.memory.non_heap_usage", VirtualMachineMetrics.nonHeapUsage(), "jvm");
        for (Map.Entry pool : VirtualMachineMetrics.memoryPoolUsage().entrySet()) {
            this.printDoubleField("jvm.memory.memory_pool_usages." + (String)pool.getKey(), (Double)pool.getValue(), "jvm");
        }
        this.printDoubleField("jvm.daemon_thread_count", VirtualMachineMetrics.daemonThreadCount(), "jvm");
        this.printDoubleField("jvm.thread_count", VirtualMachineMetrics.threadCount(), "jvm");
        this.printDoubleField("jvm.uptime", VirtualMachineMetrics.uptime(), "jvm");
        this.printDoubleField("jvm.fd_usage", VirtualMachineMetrics.fileDescriptorUsage(), "jvm");
        for (Map.Entry entry : VirtualMachineMetrics.threadStatePercentages().entrySet()) {
            this.printDoubleField("jvm.thread-states." + ((Thread.State)((Object)entry.getKey())).toString().toLowerCase(), (Double)entry.getValue(), "jvm");
        }
        for (Map.Entry entry : VirtualMachineMetrics.garbageCollectors().entrySet()) {
            this.printLongField("jvm.gc." + (String)entry.getKey() + ".time", ((VirtualMachineMetrics.GarbageCollector)entry.getValue()).getTime(TimeUnit.MILLISECONDS), "jvm");
            this.printLongField("jvm.gc." + (String)entry.getKey() + ".runs", ((VirtualMachineMetrics.GarbageCollector)entry.getValue()).getRuns(), "jvm");
        }
    }

    String getHostLabel() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostAddress() + ":" + addr.getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("Unable to get local gangliaHost name: ", (Throwable)e);
            return "unknown";
        }
    }

    protected String sanitizeName(MetricName name) {
        if (name == null) {
            return "";
        }
        String qualifiedTypeName = name.getGroup() + "." + name.getType() + "." + name.getName();
        String metricName = name.hasScope() ? qualifiedTypeName + '.' + name.getScope() : qualifiedTypeName;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < metricName.length(); ++i) {
            char p = metricName.charAt(i);
            if (!(p >= 'A' && p <= 'Z' || p >= 'a' && p <= 'z' || p >= '0' && p <= '9' || p == '_' || p == '-' || p == '.' || p == '\u0000')) {
                sb.append('_');
                continue;
            }
            sb.append(p);
        }
        return this.compressPackageName(sb.toString());
    }

    private String compressPackageName(String name) {
        if (this.compressPackageNames && name.indexOf(".") > 0) {
            String[] nameParts = name.split("\\.");
            StringBuilder sb = new StringBuilder();
            int numParts = nameParts.length;
            int count = 0;
            for (String namePart : nameParts) {
                if (++count < numParts - 1) {
                    sb.append(namePart.charAt(0));
                    sb.append(".");
                    continue;
                }
                sb.append(namePart);
                if (count != numParts - 1) continue;
                sb.append(".");
            }
            name = sb.toString();
        }
        return name;
    }
}

