/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.reporting;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;

public class GangliaMessage {
    private final byte[] buffer;
    private int offset = 0;
    private final DatagramSocket datagramSocket;
    private final InetSocketAddress inetSocketAddress;

    GangliaMessage(InetSocketAddress inetSocketAddress, byte[] buffer, DatagramSocket datagramSocket) {
        this.inetSocketAddress = inetSocketAddress;
        this.buffer = buffer;
        this.datagramSocket = datagramSocket;
    }

    public void send() throws SocketException, IOException {
        this.datagramSocket.send(new DatagramPacket(this.buffer, this.offset, this.inetSocketAddress));
    }

    public GangliaMessage addInt(int value) {
        this.buffer[this.offset++] = (byte)(value >> 24 & 0xFF);
        this.buffer[this.offset++] = (byte)(value >> 16 & 0xFF);
        this.buffer[this.offset++] = (byte)(value >> 8 & 0xFF);
        this.buffer[this.offset++] = (byte)(value & 0xFF);
        return this;
    }

    public GangliaMessage addString(String value) {
        byte[] bytes = value.getBytes();
        int len = bytes.length;
        this.addInt(len);
        System.arraycopy(bytes, 0, this.buffer, this.offset, len);
        this.offset += len;
        this.pad();
        return this;
    }

    private void pad() {
        int newOffset = (this.offset + 3) / 4 * 4;
        while (this.offset < newOffset) {
            this.buffer[this.offset++] = 0;
        }
    }

    int getOffset() {
        return this.offset;
    }
}

