/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.util;

import com.yammer.metrics.util.NamedThreadFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class ThreadPools {
    private final ConcurrentMap<String, ScheduledExecutorService> threadPools = new ConcurrentHashMap<String, ScheduledExecutorService>(100);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledExecutorService newScheduledThreadPool(int poolSize, String name) {
        ScheduledExecutorService existing = (ScheduledExecutorService)this.threadPools.get(name);
        if (existing == null) {
            ConcurrentMap<String, ScheduledExecutorService> concurrentMap = this.threadPools;
            synchronized (concurrentMap) {
                ScheduledExecutorService lastChance = (ScheduledExecutorService)this.threadPools.get(name);
                if (lastChance == null) {
                    ScheduledExecutorService service = Executors.newScheduledThreadPool(poolSize, new NamedThreadFactory(name));
                    this.threadPools.put(name, service);
                    return service;
                }
                return lastChance;
            }
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownThreadPools() {
        ConcurrentMap<String, ScheduledExecutorService> concurrentMap = this.threadPools;
        synchronized (concurrentMap) {
            for (ScheduledExecutorService executor : this.threadPools.values()) {
                executor.shutdown();
            }
            this.threadPools.clear();
        }
    }
}

