/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.core;

import com.yammer.metrics.core.Clock;
import com.yammer.metrics.core.HistogramMetric;
import com.yammer.metrics.core.MeterMetric;
import com.yammer.metrics.core.Metered;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsProcessor;
import com.yammer.metrics.core.Percentiled;
import com.yammer.metrics.core.Stoppable;
import com.yammer.metrics.core.Summarized;
import com.yammer.metrics.core.TimerContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class TimerMetric
implements Metered,
Stoppable,
Percentiled,
Summarized {
    private final TimeUnit durationUnit;
    private final TimeUnit rateUnit;
    private final MeterMetric meter;
    private final HistogramMetric histogram = new HistogramMetric(HistogramMetric.SampleType.BIASED);
    private final Clock clock;

    public TimerMetric(TimeUnit durationUnit, TimeUnit rateUnit) {
        this(durationUnit, rateUnit, Clock.DEFAULT);
    }

    public TimerMetric(TimeUnit durationUnit, TimeUnit rateUnit, Clock clock) {
        this.durationUnit = durationUnit;
        this.rateUnit = rateUnit;
        this.meter = MeterMetric.newMeter("calls", rateUnit);
        this.clock = clock;
        this.clear();
    }

    public TimerMetric(ScheduledExecutorService tickThread, TimeUnit durationUnit, TimeUnit rateUnit) {
        this(tickThread, durationUnit, rateUnit, Clock.DEFAULT);
    }

    public TimerMetric(ScheduledExecutorService tickThread, TimeUnit durationUnit, TimeUnit rateUnit, Clock clock) {
        this.durationUnit = durationUnit;
        this.rateUnit = rateUnit;
        this.meter = MeterMetric.newMeter(tickThread, "calls", rateUnit);
        this.clock = clock;
        this.clear();
    }

    public TimeUnit durationUnit() {
        return this.durationUnit;
    }

    @Override
    public TimeUnit rateUnit() {
        return this.rateUnit;
    }

    public void clear() {
        this.histogram.clear();
    }

    public void update(long duration, TimeUnit unit) {
        this.update(unit.toNanos(duration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T time(Callable<T> event) throws Exception {
        long startTime = this.clock.tick();
        try {
            T t = event.call();
            return t;
        }
        finally {
            this.update(this.clock.tick() - startTime);
        }
    }

    public TimerContext time() {
        return new TimerContext(this);
    }

    @Override
    public long count() {
        return this.histogram.count();
    }

    @Override
    public double fifteenMinuteRate() {
        return this.meter.fifteenMinuteRate();
    }

    @Override
    public double fiveMinuteRate() {
        return this.meter.fiveMinuteRate();
    }

    @Override
    public double meanRate() {
        return this.meter.meanRate();
    }

    @Override
    public double oneMinuteRate() {
        return this.meter.oneMinuteRate();
    }

    @Override
    public double max() {
        return this.convertFromNS(this.histogram.max());
    }

    @Override
    public double min() {
        return this.convertFromNS(this.histogram.min());
    }

    @Override
    public double mean() {
        return this.convertFromNS(this.histogram.mean());
    }

    @Override
    public double stdDev() {
        return this.convertFromNS(this.histogram.stdDev());
    }

    @Override
    public double percentile(double percentile) {
        return this.percentiles(percentile)[0];
    }

    @Override
    public Double[] percentiles(Double ... percentiles) {
        Double[] scores = this.histogram.percentiles(percentiles);
        for (int i = 0; i < scores.length; ++i) {
            scores[i] = this.convertFromNS(scores[i]);
        }
        return scores;
    }

    @Override
    public String eventType() {
        return this.meter.eventType();
    }

    public List<Double> values() {
        ArrayList<Double> values = new ArrayList<Double>();
        for (Long value : this.histogram.values()) {
            values.add(this.convertFromNS(value.longValue()));
        }
        return values;
    }

    public void dump(File output) throws IOException {
        this.histogram.dump(output);
    }

    private void update(long duration) {
        if (duration >= 0L) {
            this.histogram.update(duration);
            this.meter.mark();
        }
    }

    private double convertFromNS(double ns) {
        return ns / (double)TimeUnit.NANOSECONDS.convert(1L, this.durationUnit);
    }

    @Override
    public void stop() {
        this.meter.stop();
    }

    @Override
    public <T> void processWith(MetricsProcessor<T> processor, MetricName name, T context) throws Exception {
        processor.processTimer(name, this, context);
    }
}

