/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.core;

import com.yammer.metrics.core.CounterMetric;
import com.yammer.metrics.core.GaugeMetric;
import com.yammer.metrics.core.HistogramMetric;
import com.yammer.metrics.core.JmxGauge;
import com.yammer.metrics.core.MeterMetric;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistryListener;
import com.yammer.metrics.core.Stoppable;
import com.yammer.metrics.core.TimerMetric;
import com.yammer.metrics.util.ThreadPools;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.management.MalformedObjectNameException;

public class MetricsRegistry {
    private final ConcurrentMap<MetricName, Metric> metrics = this.newMetricsMap();
    private final ThreadPools threadPools = new ThreadPools();
    private final List<MetricsRegistryListener> listeners = new CopyOnWriteArrayList<MetricsRegistryListener>();

    public <T> GaugeMetric<T> newGauge(Class<?> klass, String name, GaugeMetric<T> metric) {
        return this.newGauge(klass, name, null, metric);
    }

    public <T> GaugeMetric<T> newGauge(Class<?> klass, String name, String scope, GaugeMetric<T> metric) {
        return this.newGauge(this.createName(klass, name, scope), metric);
    }

    public <T> GaugeMetric<T> newGauge(MetricName metricName, GaugeMetric<T> metric) {
        return this.getOrAdd(metricName, metric);
    }

    public JmxGauge newJmxGauge(Class<?> klass, String name, String objectName, String attribute) throws MalformedObjectNameException {
        return this.newJmxGauge(klass, name, null, objectName, attribute);
    }

    public JmxGauge newJmxGauge(Class<?> klass, String name, String scope, String objectName, String attribute) throws MalformedObjectNameException {
        return this.newJmxGauge(this.createName(klass, name, scope), objectName, attribute);
    }

    public JmxGauge newJmxGauge(MetricName metricName, String objectName, String attribute) throws MalformedObjectNameException {
        return this.getOrAdd(metricName, new JmxGauge(objectName, attribute));
    }

    public CounterMetric newCounter(Class<?> klass, String name) {
        return this.newCounter(klass, name, null);
    }

    public CounterMetric newCounter(Class<?> klass, String name, String scope) {
        return this.newCounter(this.createName(klass, name, scope));
    }

    public CounterMetric newCounter(MetricName metricName) {
        return this.getOrAdd(metricName, new CounterMetric());
    }

    public HistogramMetric newHistogram(Class<?> klass, String name, boolean biased) {
        return this.newHistogram(klass, name, null, biased);
    }

    public HistogramMetric newHistogram(Class<?> klass, String name, String scope, boolean biased) {
        return this.newHistogram(this.createName(klass, name, scope), biased);
    }

    public HistogramMetric newHistogram(Class<?> klass, String name) {
        return this.newHistogram(klass, name, false);
    }

    public HistogramMetric newHistogram(Class<?> klass, String name, String scope) {
        return this.newHistogram(klass, name, scope, false);
    }

    public HistogramMetric newHistogram(MetricName metricName, boolean biased) {
        return this.getOrAdd(metricName, new HistogramMetric(biased ? HistogramMetric.SampleType.BIASED : HistogramMetric.SampleType.UNIFORM));
    }

    public MeterMetric newMeter(Class<?> klass, String name, String eventType, TimeUnit unit) {
        return this.newMeter(klass, name, null, eventType, unit);
    }

    public MeterMetric newMeter(Class<?> klass, String name, String scope, String eventType, TimeUnit unit) {
        return this.newMeter(this.createName(klass, name, scope), eventType, unit);
    }

    public MeterMetric newMeter(MetricName metricName, String eventType, TimeUnit unit) {
        Metric existingMetric = (Metric)this.metrics.get(metricName);
        if (existingMetric != null) {
            return (MeterMetric)existingMetric;
        }
        return this.getOrAdd(metricName, MeterMetric.newMeter(this.newMeterTickThreadPool(), eventType, unit));
    }

    public TimerMetric newTimer(Class<?> klass, String name) {
        return this.newTimer(klass, name, null, TimeUnit.MILLISECONDS, TimeUnit.SECONDS);
    }

    public TimerMetric newTimer(Class<?> klass, String name, TimeUnit durationUnit, TimeUnit rateUnit) {
        return this.newTimer(klass, name, null, durationUnit, rateUnit);
    }

    public TimerMetric newTimer(Class<?> klass, String name, String scope) {
        return this.newTimer(klass, name, scope, TimeUnit.MILLISECONDS, TimeUnit.SECONDS);
    }

    public TimerMetric newTimer(Class<?> klass, String name, String scope, TimeUnit durationUnit, TimeUnit rateUnit) {
        return this.newTimer(this.createName(klass, name, scope), durationUnit, rateUnit);
    }

    public TimerMetric newTimer(MetricName metricName, TimeUnit durationUnit, TimeUnit rateUnit) {
        Metric existingMetric = (Metric)this.metrics.get(metricName);
        if (existingMetric != null) {
            return (TimerMetric)existingMetric;
        }
        return this.getOrAdd(metricName, new TimerMetric(this.newMeterTickThreadPool(), durationUnit, rateUnit));
    }

    public MetricName createName(Class<?> klass, String name, String scope) {
        return new MetricName(klass, name, scope);
    }

    public Map<MetricName, Metric> allMetrics() {
        return Collections.unmodifiableMap(this.metrics);
    }

    public ThreadPools threadPools() {
        return this.threadPools;
    }

    public ScheduledExecutorService newMeterTickThreadPool() {
        return this.threadPools.newScheduledThreadPool(2, "meter-tick");
    }

    public void removeMetric(Class<?> klass, String name) {
        this.removeMetric(klass, name, null);
    }

    public void removeMetric(Class<?> klass, String name, String scope) {
        this.removeMetric(this.createName(klass, name, scope));
    }

    public void removeMetric(MetricName name) {
        Metric metric = (Metric)this.metrics.remove(name);
        if (metric != null) {
            if (metric instanceof Stoppable) {
                ((Stoppable)((Object)metric)).stop();
            }
            this.notifyMetricRemoved(name);
        }
    }

    protected ConcurrentMap<MetricName, Metric> newMetricsMap() {
        return new ConcurrentHashMap<MetricName, Metric>(1024);
    }

    protected final <T extends Metric> T getOrAdd(MetricName name, T metric) {
        Metric existingMetric = (Metric)this.metrics.get(name);
        if (existingMetric == null) {
            Metric justAddedMetric = this.metrics.putIfAbsent(name, metric);
            if (justAddedMetric == null) {
                this.notifyMetricAdded(name, metric);
                return metric;
            }
            if (metric instanceof Stoppable) {
                ((Stoppable)((Object)metric)).stop();
            }
            return (T)justAddedMetric;
        }
        return (T)existingMetric;
    }

    public void addListener(MetricsRegistryListener listener) {
        this.listeners.add(listener);
        for (Map.Entry entry : this.metrics.entrySet()) {
            listener.onMetricAdded((MetricName)entry.getKey(), (Metric)entry.getValue());
        }
    }

    public void removeListener(MetricsRegistryListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyMetricRemoved(MetricName name) {
        for (MetricsRegistryListener listener : this.listeners) {
            listener.onMetricRemoved(name);
        }
    }

    private void notifyMetricAdded(MetricName name, Metric metric) {
        for (MetricsRegistryListener listener : this.listeners) {
            listener.onMetricAdded(name, metric);
        }
    }
}

