/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.core;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

class LoggerMemoryLeakFix
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(LoggerMemoryLeakFix.class.getCanonicalName());
    private final Field kidsField = Logger.class.getDeclaredField("kids");
    private final Field lockField;

    public LoggerMemoryLeakFix() throws NoSuchFieldException, IllegalAccessException {
        this.kidsField.setAccessible(true);
        this.kidsField.get(LOGGER);
        this.lockField = Logger.class.getDeclaredField("treeLock");
        this.lockField.setAccessible(true);
        this.lockField.get(LOGGER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Enumeration<String> names = LogManager.getLogManager().getLoggerNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            Logger logger = LogManager.getLogManager().getLogger(name);
            LOGGER.fine("Removing null kid entries from logger \"" + name + "\"");
            if (logger == null) continue;
            try {
                Object lock = this.lockField.get(logger);
                if (lock == null) {
                    throw new IllegalStateException("can't find the lock on logger \"" + name + "\"");
                }
                int removed = 0;
                Object object = lock;
                synchronized (object) {
                    ArrayList kids = (ArrayList)this.kidsField.get(logger);
                    if (kids != null) {
                        for (int i = kids.size() - 1; i >= 0; --i) {
                            if (((WeakReference)kids.get(i)).get() != null) continue;
                            ++removed;
                            kids.remove(i);
                        }
                        if (removed > 0) {
                            LOGGER.fine("Removed " + removed + " null WeakReference instances");
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Error cleaning out logger", e);
            }
        }
    }
}

