/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.core;

import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsProcessor;
import com.yammer.metrics.core.Percentiled;
import com.yammer.metrics.core.Summarized;
import com.yammer.metrics.stats.ExponentiallyDecayingSample;
import com.yammer.metrics.stats.Sample;
import com.yammer.metrics.stats.UniformSample;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class HistogramMetric
implements Metric,
Percentiled,
Summarized {
    private final Sample sample;
    private final AtomicLong _min = new AtomicLong();
    private final AtomicLong _max = new AtomicLong();
    private final AtomicLong _sum = new AtomicLong();
    private final AtomicReference<double[]> variance = new AtomicReference<double[]>(new double[]{-1.0, 0.0});
    private final AtomicLong count = new AtomicLong();
    private final ThreadLocal<double[]> arrayCache = new ThreadLocal<double[]>(){

        @Override
        protected double[] initialValue() {
            return new double[2];
        }
    };

    public HistogramMetric(SampleType type) {
        this(type.newSample());
    }

    public HistogramMetric(Sample sample) {
        this.sample = sample;
        this.clear();
    }

    public void clear() {
        this.sample.clear();
        this.count.set(0L);
        this._max.set(Long.MIN_VALUE);
        this._min.set(Long.MAX_VALUE);
        this._sum.set(0L);
        this.variance.set(new double[]{-1.0, 0.0});
    }

    public void update(int value) {
        this.update((long)value);
    }

    public void update(long value) {
        this.count.incrementAndGet();
        this.sample.update(value);
        this.setMax(value);
        this.setMin(value);
        this._sum.getAndAdd(value);
        this.updateVariance(value);
    }

    public long count() {
        return this.count.get();
    }

    @Override
    public double max() {
        if (this.count() > 0L) {
            return this._max.get();
        }
        return 0.0;
    }

    @Override
    public double min() {
        if (this.count() > 0L) {
            return this._min.get();
        }
        return 0.0;
    }

    @Override
    public double mean() {
        if (this.count() > 0L) {
            return (double)this._sum.get() / (double)this.count();
        }
        return 0.0;
    }

    @Override
    public double stdDev() {
        if (this.count() > 0L) {
            return Math.sqrt(this.variance());
        }
        return 0.0;
    }

    @Override
    public double percentile(double percentile) {
        return this.percentiles(percentile)[0];
    }

    @Override
    public Double[] percentiles(Double ... percentiles) {
        Double[] scores = new Double[percentiles.length];
        for (int i = 0; i < scores.length; ++i) {
            scores[i] = 0.0;
        }
        if (this.count() > 0L) {
            List<Long> values = this.sample.values();
            Collections.sort(values);
            for (int i = 0; i < percentiles.length; ++i) {
                double p = percentiles[i];
                double pos = p * (double)(values.size() + 1);
                if (pos < 1.0) {
                    scores[i] = (double)values.get(0);
                    continue;
                }
                if (pos >= (double)values.size()) {
                    scores[i] = (double)values.get(values.size() - 1);
                    continue;
                }
                double lower = values.get((int)pos - 1).longValue();
                double upper = values.get((int)pos).longValue();
                scores[i] = lower + (pos - Math.floor(pos)) * (upper - lower);
            }
        }
        return scores;
    }

    public List<Long> values() {
        return this.sample.values();
    }

    public void dump(File output) throws IOException {
        this.sample.dump(output);
    }

    private double variance() {
        if (this.count() <= 1L) {
            return 0.0;
        }
        return this.variance.get()[1] / (double)(this.count() - 1L);
    }

    private void setMax(long potentialMax) {
        boolean done = false;
        while (!done) {
            long currentMax = this._max.get();
            done = currentMax >= potentialMax || this._max.compareAndSet(currentMax, potentialMax);
        }
    }

    private void setMin(long potentialMin) {
        boolean done = false;
        while (!done) {
            long currentMin = this._min.get();
            done = currentMin <= potentialMin || this._min.compareAndSet(currentMin, potentialMin);
        }
    }

    private void updateVariance(long value) {
        boolean done = false;
        while (!done) {
            double[] oldValues = this.variance.get();
            double[] newValues = this.arrayCache.get();
            if (oldValues[0] == -1.0) {
                newValues[0] = value;
                newValues[1] = 0.0;
            } else {
                double oldM = oldValues[0];
                double oldS = oldValues[1];
                double newM = oldM + ((double)value - oldM) / (double)this.count();
                double newS = oldS + ((double)value - oldM) * ((double)value - newM);
                newValues[0] = newM;
                newValues[1] = newS;
            }
            if (!(done = this.variance.compareAndSet(oldValues, newValues))) continue;
            this.arrayCache.set(oldValues);
        }
    }

    @Override
    public <T> void processWith(MetricsProcessor<T> processor, MetricName name, T context) throws Exception {
        processor.processHistogram(name, this, context);
    }

    public static enum SampleType {
        UNIFORM{

            @Override
            public Sample newSample() {
                return new UniformSample(1028);
            }
        }
        ,
        BIASED{

            @Override
            public Sample newSample() {
                return new ExponentiallyDecayingSample(1028, 0.015);
            }
        };


        public abstract Sample newSample();
    }
}

