/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.core;

import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsProcessor;
import java.util.concurrent.atomic.AtomicLong;

public class CounterMetric
implements Metric {
    private final AtomicLong count = new AtomicLong(0L);

    public void inc() {
        this.inc(1L);
    }

    public void inc(long n) {
        this.count.addAndGet(n);
    }

    public void dec() {
        this.dec(1L);
    }

    public void dec(long n) {
        this.count.addAndGet(0L - n);
    }

    public long count() {
        return this.count.get();
    }

    public void clear() {
        this.count.set(0L);
    }

    @Override
    public <T> void processWith(MetricsProcessor<T> processor, MetricName name, T context) throws Exception {
        processor.processCounter(name, this, context);
    }
}

