/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.core;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

public abstract class Clock {
    public static final Clock DEFAULT = new UserTime();

    public abstract long tick();

    public long time() {
        return System.currentTimeMillis();
    }

    public static class CpuTime
    extends Clock {
        private static final ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();

        @Override
        public long tick() {
            return threadMxBean.getCurrentThreadCpuTime();
        }
    }

    public static class UserTime
    extends Clock {
        @Override
        public long tick() {
            return System.nanoTime();
        }
    }
}

