/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics;

import com.yammer.metrics.core.CounterMetric;
import com.yammer.metrics.core.GaugeMetric;
import com.yammer.metrics.core.HistogramMetric;
import com.yammer.metrics.core.JmxGauge;
import com.yammer.metrics.core.MeterMetric;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.TimerMetric;
import com.yammer.metrics.core.VirtualMachineMetrics;
import com.yammer.metrics.reporting.ConsoleReporter;
import com.yammer.metrics.reporting.JmxReporter;
import com.yammer.metrics.util.Utils;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.MalformedObjectNameException;

public class Metrics {
    private static final MetricsRegistry DEFAULT_REGISTRY = new MetricsRegistry();
    private static final Thread SHUTDOWN_HOOK = new Thread(){

        @Override
        public void run() {
            JmxReporter.shutdownDefault();
        }
    };

    private Metrics() {
    }

    public static <T> GaugeMetric<T> newGauge(Class<?> klass, String name, GaugeMetric<T> metric) {
        return DEFAULT_REGISTRY.newGauge(klass, name, metric);
    }

    public static <T> GaugeMetric<T> newGauge(Class<?> klass, String name, String scope, GaugeMetric<T> metric) {
        return DEFAULT_REGISTRY.newGauge(klass, name, scope, metric);
    }

    public static <T> GaugeMetric<T> newGauge(MetricName metricName, GaugeMetric<T> metric) {
        return DEFAULT_REGISTRY.newGauge(metricName, metric);
    }

    public static JmxGauge newJmxGauge(Class<?> klass, String name, String objectName, String attribute) throws MalformedObjectNameException {
        return DEFAULT_REGISTRY.newJmxGauge(klass, name, null, objectName, attribute);
    }

    public static JmxGauge newJmxGauge(Class<?> klass, String name, String scope, String objectName, String attribute) throws MalformedObjectNameException {
        return DEFAULT_REGISTRY.newJmxGauge(klass, name, scope, objectName, attribute);
    }

    public static JmxGauge newJmxGauge(MetricName metricName, String objectName, String attribute) throws MalformedObjectNameException {
        return DEFAULT_REGISTRY.newJmxGauge(metricName, objectName, attribute);
    }

    public static CounterMetric newCounter(Class<?> klass, String name) {
        return DEFAULT_REGISTRY.newCounter(klass, name);
    }

    public static CounterMetric newCounter(Class<?> klass, String name, String scope) {
        return DEFAULT_REGISTRY.newCounter(klass, name, scope);
    }

    public static CounterMetric newCounter(MetricName metricName) {
        return DEFAULT_REGISTRY.newCounter(metricName);
    }

    public static HistogramMetric newHistogram(Class<?> klass, String name, boolean biased) {
        return DEFAULT_REGISTRY.newHistogram(klass, name, biased);
    }

    public static HistogramMetric newHistogram(Class<?> klass, String name, String scope, boolean biased) {
        return DEFAULT_REGISTRY.newHistogram(klass, name, scope, biased);
    }

    public static HistogramMetric newHistogram(MetricName metricName, boolean biased) {
        return DEFAULT_REGISTRY.newHistogram(metricName, biased);
    }

    public static HistogramMetric newHistogram(Class<?> klass, String name) {
        return DEFAULT_REGISTRY.newHistogram(klass, name);
    }

    public static HistogramMetric newHistogram(Class<?> klass, String name, String scope) {
        return DEFAULT_REGISTRY.newHistogram(klass, name, scope);
    }

    public static HistogramMetric newHistogram(MetricName metricName) {
        return Metrics.newHistogram(metricName, false);
    }

    public static MeterMetric newMeter(Class<?> klass, String name, String eventType, TimeUnit unit) {
        return DEFAULT_REGISTRY.newMeter(klass, name, eventType, unit);
    }

    public static MeterMetric newMeter(Class<?> klass, String name, String scope, String eventType, TimeUnit unit) {
        return DEFAULT_REGISTRY.newMeter(klass, name, scope, eventType, unit);
    }

    public static MeterMetric newMeter(MetricName metricName, String eventType, TimeUnit unit) {
        return DEFAULT_REGISTRY.newMeter(metricName, eventType, unit);
    }

    public static TimerMetric newTimer(Class<?> klass, String name, TimeUnit durationUnit, TimeUnit rateUnit) {
        return DEFAULT_REGISTRY.newTimer(klass, name, durationUnit, rateUnit);
    }

    public static TimerMetric newTimer(Class<?> klass, String name) {
        return DEFAULT_REGISTRY.newTimer(klass, name);
    }

    public static TimerMetric newTimer(Class<?> klass, String name, String scope, TimeUnit durationUnit, TimeUnit rateUnit) {
        return DEFAULT_REGISTRY.newTimer(klass, name, scope, durationUnit, rateUnit);
    }

    public static TimerMetric newTimer(Class<?> klass, String name, String scope) {
        return DEFAULT_REGISTRY.newTimer(klass, name, scope);
    }

    public static TimerMetric newTimer(MetricName metricName, TimeUnit durationUnit, TimeUnit rateUnit) {
        return DEFAULT_REGISTRY.newTimer(metricName, durationUnit, rateUnit);
    }

    public static void removeMetric(MetricName name) {
        DEFAULT_REGISTRY.removeMetric(name);
    }

    public static void removeMetric(Class<?> klass, String name) {
        DEFAULT_REGISTRY.removeMetric(klass, name);
    }

    public static void removeMetric(Class<?> klass, String name, String scope) {
        DEFAULT_REGISTRY.removeMetric(klass, name, scope);
    }

    @Deprecated
    public static void enableConsoleReporting(long period, TimeUnit unit) {
        ConsoleReporter.enable(DEFAULT_REGISTRY, period, unit);
    }

    public static Map<MetricName, Metric> allMetrics() {
        return DEFAULT_REGISTRY.allMetrics();
    }

    public static MetricsRegistry defaultRegistry() {
        return DEFAULT_REGISTRY;
    }

    public static void shutdown() {
        Utils.shutdownThreadPools();
        DEFAULT_REGISTRY.threadPools().shutdownThreadPools();
        JmxReporter.shutdownDefault();
        Runtime.getRuntime().removeShutdownHook(SHUTDOWN_HOOK);
    }

    static {
        JmxReporter.startDefault(DEFAULT_REGISTRY);
        VirtualMachineMetrics.daemonThreadCount();
        Runtime.getRuntime().addShutdownHook(SHUTDOWN_HOOK);
    }
}

