/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import com.vaadin.external.org.slf4j.Logger;
import com.vaadin.external.org.slf4j.LoggerFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResourceImpl;

public class SuspendTrackerInterceptor
extends AtmosphereInterceptorAdapter {
    private final Set<String> trackedUUID = Collections.synchronizedSet(new HashSet());
    private final Logger logger = LoggerFactory.getLogger(SuspendTrackerInterceptor.class);

    @Override
    public Action inspect(final AtmosphereResource r) {
        if (!r.uuid().equals("0")) {
            if (!this.trackedUUID.add(r.uuid())) {
                this.logger.trace("Blocking {} from suspend", (Object)r.uuid());
                ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).disableSuspendEvent(true);
            }
            r.addEventListener(new AtmosphereResourceEventListenerAdapter.OnDisconnect(){

                @Override
                public void onDisconnect(AtmosphereResourceEvent event) {
                    SuspendTrackerInterceptor.this.logger.trace("Untracking {}", (Object)r.uuid());
                    SuspendTrackerInterceptor.this.trackedUUID.remove(r.uuid());
                }
            });
        }
        return Action.CONTINUE;
    }

    @Override
    public String toString() {
        return "UUID Tracking Interceptor";
    }
}

