/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.secconv.impl.client;

import com.sun.xml.ws.api.security.secconv.client.SCTokenConfiguration;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.api.security.trust.client.IssuedTokenProvider;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.SecurityContextTokenInfo;
import com.sun.xml.ws.security.impl.policyconv.IntegrityAssertionProcessor;
import com.sun.xml.ws.security.impl.policyconv.SecurityPolicyUtil;
import com.sun.xml.ws.security.impl.policyconv.SignatureTargetCreator;
import com.sun.xml.ws.security.secconv.WSSCFactory;
import com.sun.xml.ws.security.secconv.WSSCPlugin;
import com.sun.xml.ws.security.secconv.WSSecureConversationException;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.policy.PolicyGenerationException;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.SignatureTarget;
import com.sun.xml.wss.impl.policy.mls.Target;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;

public class SCTokenProviderImpl
implements IssuedTokenProvider {
    private static final WSSCPlugin scp = WSSCFactory.newSCPlugin(null);
    private Hashtable<String, IssuedTokenContext> issuedTokenContextMap = new Hashtable();
    private Hashtable<String, SecurityContextTokenInfo> securityContextTokenMap = new Hashtable();

    public void issue(IssuedTokenContext ctx) throws WSTrustException {
        SCTokenConfiguration sctConfig = (SCTokenConfiguration)ctx.getSecurityPolicy().get(0);
        if (this.issuedTokenContextMap.get(sctConfig.getTokenId()) != null) {
            if (sctConfig.isExpired()) {
                ctx = this.issuedTokenContextMap.get(sctConfig.getTokenId());
                this.renew(ctx);
            } else {
                this.getSecurityContextToken(sctConfig.getTokenId(), sctConfig.checkTokenExpiry());
            }
        } else if (sctConfig.getMessagePolicy() != null) {
            try {
                if (sctConfig.addRenewPolicy()) {
                    this.appendEndorsingSCTRenewPolicy(sctConfig.getMessagePolicy());
                }
                this.deleteRenewPolicy(sctConfig.getMessagePolicy());
            }
            catch (PolicyGenerationException e) {
                throw new WSTrustException(e.getMessage());
            }
        } else {
            scp.process(ctx);
            this.addSecurityContextToken(sctConfig.getTokenId(), ctx);
            this.addSecurityContextToken(((SecurityContextToken)ctx.getSecurityToken()).getIdentifier().toString(), ctx);
        }
    }

    public void cancel(IssuedTokenContext ctx) throws WSTrustException {
        scp.processCancellation(ctx);
    }

    public void renew(IssuedTokenContext ctx) throws WSTrustException {
        scp.processRenew(ctx);
        this.addSecurityContextTokenInfo(((SecurityContextToken)ctx.getSecurityToken()).getInstance(), ctx.getSecurityContextTokenInfo());
    }

    public void validate(IssuedTokenContext ctx) throws WSTrustException {
    }

    private void addSecurityContextToken(String key, IssuedTokenContext itctx) {
        this.issuedTokenContextMap.put(key, itctx);
    }

    private void addSecurityContextTokenInfo(String key, SecurityContextTokenInfo sctInfo) {
        this.securityContextTokenMap.put(key, sctInfo);
    }

    private IssuedTokenContext getSecurityContextToken(String key, boolean expiryCheck) throws WSSecureConversationException {
        IssuedTokenContext ctx = this.issuedTokenContextMap.get(key);
        if (ctx != null && expiryCheck) {
            GregorianCalendar c = new GregorianCalendar();
            long offset = c.get(15);
            if (((Calendar)c).getTimeZone().inDaylightTime(c.getTime())) {
                offset += (long)((Calendar)c).getTimeZone().getDSTSavings();
            }
            long beforeTime = c.getTimeInMillis();
            long currentTime = beforeTime - offset;
            c.setTimeInMillis(currentTime);
            Date currentTimeInDateFormat = c.getTime();
            if (!currentTimeInDateFormat.after(ctx.getCreationTime()) || !currentTimeInDateFormat.before(ctx.getExpirationTime())) {
                throw new WSSecureConversationException("SecureConversation session for session Id:" + key + "has expired.");
            }
        }
        return ctx;
    }

    public SecurityContextTokenInfo getSecurityContextTokenInfo(String key) {
        SecurityContextTokenInfo ctx = this.securityContextTokenMap.get(key);
        return ctx;
    }

    private void appendEndorsingSCTRenewPolicy(MessagePolicy policy) throws PolicyGenerationException {
        SignaturePolicy sp = scp.getRenewSignaturePolicy();
        SignaturePolicy.FeatureBinding spFB = (SignaturePolicy.FeatureBinding)sp.getFeatureBinding();
        ArrayList list = policy.getPrimaryPolicies();
        for (SecurityPolicy primaryPolicy : list) {
            if (!PolicyTypeUtil.signaturePolicy(primaryPolicy)) continue;
            SignaturePolicy sigPolicy = (SignaturePolicy)primaryPolicy;
            IntegrityAssertionProcessor iAP = new IntegrityAssertionProcessor(scp.getAlgorithmSuite(), true);
            SignatureTargetCreator stc = iAP.getTargetCreator();
            SignatureTarget sigTarget = stc.newURISignatureTarget(sigPolicy.getUUID());
            SecurityPolicyUtil.setName((Target)sigTarget, (WSSPolicy)sigPolicy);
            spFB.addTargetBinding(sigTarget);
            spFB.isEndorsingSignature(true);
            break;
        }
        policy.append(sp);
    }

    private void deleteRenewPolicy(MessagePolicy policy) {
        ArrayList list = policy.getPrimaryPolicies();
        for (SecurityPolicy primaryPolicy : list) {
            SignaturePolicy sigPolicy;
            if (!PolicyTypeUtil.signaturePolicy(primaryPolicy) || !(sigPolicy = (SignaturePolicy)primaryPolicy).getUUID().equals("_99")) continue;
            policy.remove(sigPolicy);
            break;
        }
    }
}

