/*
 * $Id: SubjectConfirmationData.java,v 1.4 2007/01/08 16:05:59 shyam_rao Exp $
 */

/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */

package com.sun.xml.wss.saml.assertion.saml20.jaxb20;

import com.sun.xml.wss.saml.SAMLException;


import com.sun.xml.wss.logging.LogDomainConstants;
import com.sun.xml.wss.saml.internal.saml20.jaxb20.SubjectConfirmationDataType;
import com.sun.xml.wss.saml.util.SAML20JAXBUtil;
import java.util.logging.Logger;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.DatatypeConfigurationException;
import java.security.PublicKey;

import javax.xml.bind.JAXBContext;
import org.w3c.dom.Element;

/**
 * The <code>SubjectConfirmationData</code> element specifies a subject by specifying data that
 * authenticates the subject.
 */
public class SubjectConfirmationData extends SubjectConfirmationDataType
        implements com.sun.xml.wss.saml.SubjectConfirmationData {
    
    protected PublicKey keyInfoKeyValue = null;
    
    protected static final Logger log = Logger.getLogger(
            LogDomainConstants.WSS_API_DOMAIN,
            LogDomainConstants.WSS_API_DOMAIN_BUNDLE);
    
    
    public SubjectConfirmationData(){
        
    }
                
    /**
     * Constructs a subject confirmation element from an existing
     * XML block.
     *
     * @param SubjectConfirmationDataElement a DOM Element representing the
     *        <code>SubjectConfirmationData</code> object.
     * @throws SAMLException
     */
    public static SubjectConfirmationDataType fromElement(org.w3c.dom.Element element)
    throws SAMLException {
        try {
            JAXBContext jc = SAML20JAXBUtil.getJAXBContext();
                    
            javax.xml.bind.Unmarshaller u = jc.createUnmarshaller();
            return (SubjectConfirmationDataType)u.unmarshal(element);
        } catch ( Exception ex) {
            throw new SAMLException(ex.getMessage());
        }
    }
    
    /**
     * Constructs an <code>SubjectConfirmationData</code> instance.
     *
     * @param confirmationMethods A set of <code>confirmationMethods</code>
     *        each of which is a URI (String) that identifies a protocol
     *        used to authenticate a <code>Subject</code>. Please refer to
     *        <code>draft-sstc-core-25</code> Section 7 for
     *        a list of URIs identifying common authentication protocols.
     * @param SubjectConfirmationDataData Additional authentication information to
     *        be used by a specific authentication protocol. Can be passed as
     *        null if there is no <code>SubjectConfirmationDataData</code> for the
     *        <code>SubjectConfirmationData</code> object.
     * @param keyInfo An XML signature element that specifies a cryptographic
     *        key held by the <code>Subject</code>.
     * @exception SAMLException if the input data is invalid or
     *            <code>confirmationMethods</code> is empty.
     */
    public SubjectConfirmationData(
        String address, String inResponseTo, GregorianCalendar notBefore, 
        GregorianCalendar notOnOrAfter, String recipient, Element keyInfo) throws SAMLException {
        
//        JAXBContext jc = null;
//        javax.xml.bind.Unmarshaller u = null;
//        
//        //Unmarshal to JAXB KeyInfo Object and set it
//        try {
//            jc = SAML20JAXBUtil.getJAXBContext();
//           u = jc.createUnmarshaller();
//        } catch ( Exception ex) {
//            throw new SAMLException(ex.getMessage());
//        }
        
//        try {
//            if ( keyInfo != null) {
//                setKeyInfo((KeyInfoType)((JAXBElement)u.unmarshal(keyInfo)).getValue());
//            }
//            if ( SubjectConfirmationDataData != null) {
//                setSubjectConfirmationDataData((SubjectConfirmationDataType)((JAXBElement)u.unmarshal(SubjectConfirmationDataData)).getValue());
//            }
//        } catch (Exception ex) {
//            // log here
//            throw new SAMLException(ex);
//        }
        setAddress(address);
        setInResponseTo(inResponseTo);
        if ( notBefore != null) {
            try {
                DatatypeFactory factory = DatatypeFactory.newInstance();
                setNotBefore(factory.newXMLGregorianCalendar(notBefore));
            }catch ( DatatypeConfigurationException ex ) {
                //ignore
            }
        }
        
        if ( notOnOrAfter != null) {
            try {
                DatatypeFactory factory = DatatypeFactory.newInstance();
                setNotOnOrAfter(factory.newXMLGregorianCalendar(notOnOrAfter));
            }catch ( DatatypeConfigurationException ex ) {
                //ignore
            }
        }
        
        setRecipient(recipient);        
        
        if (keyInfo != null){
            this.getContent().add(keyInfo);
        }
    }
}
