/*

 * The contents of this file are subject to the terms

 * of the Common Development and Distribution License

 * (the "License").  You may not use this file except

 * in compliance with the License.

 *

 * You can obtain a copy of the license at

 * https://jwsdp.dev.java.net/CDDLv1.0.html

 * See the License for the specific language governing

 * permissions and limitations under the License.

 *

 * When distributing Covered Code, include this CDDL

 * HEADER in each file and include the License file at

 * https://jwsdp.dev.java.net/CDDLv1.0.html  If applicable,

 * add the following below this CDDL HEADER, with the

 * fields enclosed by brackets "[]" replaced with your

 * own identifying information: Portions Copyright [yyyy]

 * [name of copyright owner]

 */

/*

 * $Id: ServerSecurityAuthModule.java,v 1.4 2007/01/08 16:06:42 shyam_rao Exp $

 *

 * Copyright 2004 Sun Microsystems, Inc. All rights reserved.

 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.

 */



package com.sun.xml.wss.provider;



import java.util.Map;

import java.util.Set;

import java.util.Iterator;



import javax.xml.soap.SOAPMessage;

import javax.xml.soap.SOAPException;

import javax.security.auth.Subject;

import javax.security.auth.Destroyable;

import javax.security.auth.DestroyFailedException;

import javax.security.auth.callback.CallbackHandler;



import com.sun.enterprise.security.jauth.AuthParam;

import com.sun.enterprise.security.jauth.AuthPolicy;

import com.sun.enterprise.security.jauth.SOAPAuthParam;

import com.sun.enterprise.security.jauth.AuthException;

import com.sun.enterprise.security.jauth.ServerAuthModule;



import com.sun.xml.wss.impl.SecurityAnnotator;

import com.sun.xml.wss.impl.SecurityRecipient;

import com.sun.xml.wss.impl.SecurableSoapMessage;

import com.sun.xml.wss.XWSSecurityException;

import com.sun.xml.wss.impl.ProcessingContextImpl;



import com.sun.xml.wss.impl.policy.mls.MessagePolicy;

import com.sun.xml.wss.impl.config.DeclarativeSecurityConfiguration;



import com.sun.xml.wss.impl.WssProviderSecurityEnvironment;



import com.sun.xml.wss.impl.MessageConstants;



public class ServerSecurityAuthModule extends WssProviderAuthModule 

                                      implements ServerAuthModule {



       public ServerSecurityAuthModule() {

       }



       public void initialize (AuthPolicy requestPolicy,

                               AuthPolicy responsePolicy,

                               CallbackHandler handler,

                               Map options) {

            super.initialize(requestPolicy, responsePolicy, handler, options, false);  

       }



       public void validateRequest (AuthParam param,

                                    Subject subject,

                                    Map sharedState)

                   throws AuthException {

             try {



                 ProcessingContextImpl context = new ProcessingContextImpl();



                 _sEnvironment.setRequesterSubject(subject, context.getExtraneousProperties());



                 MessagePolicy receiverCnfg = 

                 ((DeclarativeSecurityConfiguration)_policy).receiverSettings();

 

                 context.setSecurityPolicy(receiverCnfg);

                 context.setSOAPMessage(((SOAPAuthParam)param).getRequest());

                 context.setSecurityEnvironment(_sEnvironment);



                 SecurityRecipient.validateMessage(context); 



                 populateSharedStateFromContext(sharedState, context);

 

                 context.getSecurableSoapMessage().deleteSecurityHeader();



             } catch (XWSSecurityException xwsse) {

                xwsse.printStackTrace();

                throw new AuthException(xwsse.getMessage());

             }

       }



       public void secureResponse (AuthParam param,

                                   Subject subject,

                                   Map sharedState)

                   throws AuthException {

             try {



               ProcessingContextImpl context = new ProcessingContextImpl();

               _sEnvironment.setSubject(subject, context.getExtraneousProperties());



               populateContextFromSharedState(context, sharedState);



 

               MessagePolicy senderCnfg = 

                 ((DeclarativeSecurityConfiguration)_policy).senderSettings();

              

               SOAPMessage msg = ((SOAPAuthParam)param).getResponse();

               context.setSecurityPolicy(senderCnfg);

               context.setSOAPMessage(msg);

               context.setSecurityEnvironment(_sEnvironment);



                if (optimize  != MessageConstants.NOT_OPTIMIZED  && isOptimized(msg)) {

                      context.setConfigType(optimize);

                } else {

		    try{

                      msg.getSOAPBody();

                      msg.getSOAPHeader();

                      context.setConfigType(MessageConstants.NOT_OPTIMIZED);

		    }catch(SOAPException ex){

			throw new AuthException(ex.getMessage());

		    }

                }



               SecurityAnnotator.secureMessage(context);

               



             } catch (XWSSecurityException xwsse) {

               xwsse.printStackTrace();

               throw new AuthException(xwsse.getMessage());

             } 

       }



       public void disposeSubject (Subject subject,

                                   Map sharedState)

                   throws AuthException {

             if (subject == null) {

                // log

                throw new AuthException("Subject is null in disposeSubject");

             }



             if (!subject.isReadOnly()) {

                 // log

                 //subject = new Subject();

                 return;

             }



             Set principals = subject.getPrincipals();

             Set privateCredentials = subject.getPrivateCredentials();

             Set publicCredentials = subject.getPublicCredentials();



             try {

                principals.clear();

             } catch (UnsupportedOperationException uoe) {

                // log

             }



             Iterator pi = privateCredentials.iterator();

             while (pi.hasNext()) {

                try {

                    Destroyable dstroyable = 

                                   (Destroyable)pi.next();

                    dstroyable.destroy(); 

                } catch (DestroyFailedException dfe) {

                   // log

                } catch (ClassCastException cce) {

                   // log

                }  

             }



             Iterator qi = publicCredentials.iterator();

             while (qi.hasNext()) {

              try {

                    Destroyable dstroyable = 

                                   (Destroyable)qi.next();

                    dstroyable.destroy(); 

                } catch (DestroyFailedException dfe) {

                   // log

                } catch (ClassCastException cce) {

                   // log

                }   

             }       

       }        



       private void populateContextFromSharedState(ProcessingContextImpl context, Map sharedState) {

           context.setExtraneousProperty(

               MessageConstants.AUTH_SUBJECT, sharedState.get(REQUESTER_SUBJECT));

           context.setExtraneousProperty(

               MessageConstants.REQUESTER_KEYID, sharedState.get(REQUESTER_KEYID));

           context.setExtraneousProperty(

               MessageConstants.REQUESTER_ISSUERNAME, sharedState.get(REQUESTER_ISSUERNAME));

           context.setExtraneousProperty(

               MessageConstants.REQUESTER_SERIAL, sharedState.get(REQUESTER_SERIAL));

       }



       private void populateSharedStateFromContext(Map sharedState, ProcessingContextImpl context) {

           sharedState.put(

               REQUESTER_SUBJECT, context.getExtraneousProperty(MessageConstants.AUTH_SUBJECT));

           sharedState.put(

               REQUESTER_KEYID, context.getExtraneousProperty(MessageConstants.REQUESTER_KEYID));

           sharedState.put(

               REQUESTER_ISSUERNAME, 

                   context.getExtraneousProperty(MessageConstants.REQUESTER_ISSUERNAME));

           sharedState.put(

               REQUESTER_SERIAL, context.getExtraneousProperty(MessageConstants.REQUESTER_SERIAL));



       }

}

