/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */


/**
 * Base class for all KeyBindings 
 *
 */
package com.sun.xml.wss.impl.policy.mls;

public abstract class KeyBindingBase extends WSSPolicy {
     //added for policy integration
    public static final String INCLUDE_ONCE = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Once".intern() ;
    public static final String INCLUDE_NEVER = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Never".intern();
    public static final String INCLUDE_ALWAYS_TO_RECIPIENT = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/AlwaysToRecipient".intern();
    public static final String INCLUDE_ALWAYS="http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Always".intern();
    
    //protected com.sun.xml.ws.security.policy.Token policyToken;
    protected boolean policyToken = false;
    protected String includeToken = INCLUDE_ALWAYS;

    /*public void setPolicyToken(com.sun.xml.ws.security.policy.Token tok) {
       // policyToken = tok;
    }*/
        
    protected String issuer;
    protected byte[] claims;
    protected String claimsDialect;
    
    public boolean policyTokenWasSet() {
        return policyToken;
    }

    public void setPolicyTokenFlag(boolean flag) {
        policyToken = flag;
    }
    
    public void setIncludeToken(String include){
        if (INCLUDE_ONCE.equals(include)) {
            throw new UnsupportedOperationException("IncludeToken Policy ONCE is not yet Supported");
        }
        this.includeToken = include;
        policyToken = true;
    }
    
    public String getIncludeToken(){
        return includeToken;
    }
    
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }
    
    public String getIssuer() {
        return issuer;
    }
    
    public void setClaims(byte[] claims) {
        this.claims = claims;
    }
    
    public byte[] getClaims() {
        return claims;
    }
}
